/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.base.security;

import com.facebook.presto.spi.CatalogSchemaName;
import com.facebook.presto.spi.CatalogSchemaTableName;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.security.Privilege;
import com.facebook.presto.spi.security.SystemAccessControl;
import java.security.Principal;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

public abstract class ForwardingSystemAccessControl
implements SystemAccessControl {
    public static SystemAccessControl of(final Supplier<SystemAccessControl> systemAccessControlSupplier) {
        Objects.requireNonNull(systemAccessControlSupplier, "systemAccessControlSupplier is null");
        return new ForwardingSystemAccessControl(){

            @Override
            protected SystemAccessControl delegate() {
                return (SystemAccessControl)systemAccessControlSupplier.get();
            }
        };
    }

    protected abstract SystemAccessControl delegate();

    public void checkCanSetUser(Optional<Principal> principal, String userName) {
        this.delegate().checkCanSetUser(principal, userName);
    }

    public void checkCanSetSystemSessionProperty(Identity identity, String propertyName) {
        this.delegate().checkCanSetSystemSessionProperty(identity, propertyName);
    }

    public void checkCanAccessCatalog(Identity identity, String catalogName) {
        this.delegate().checkCanAccessCatalog(identity, catalogName);
    }

    public Set<String> filterCatalogs(Identity identity, Set<String> catalogs) {
        return this.delegate().filterCatalogs(identity, catalogs);
    }

    public void checkCanCreateSchema(Identity identity, CatalogSchemaName schema) {
        this.delegate().checkCanCreateSchema(identity, schema);
    }

    public void checkCanDropSchema(Identity identity, CatalogSchemaName schema) {
        this.delegate().checkCanDropSchema(identity, schema);
    }

    public void checkCanRenameSchema(Identity identity, CatalogSchemaName schema, String newSchemaName) {
        this.delegate().checkCanRenameSchema(identity, schema, newSchemaName);
    }

    public void checkCanShowSchemas(Identity identity, String catalogName) {
        this.delegate().checkCanShowSchemas(identity, catalogName);
    }

    public Set<String> filterSchemas(Identity identity, String catalogName, Set<String> schemaNames) {
        return this.delegate().filterSchemas(identity, catalogName, schemaNames);
    }

    public void checkCanCreateTable(Identity identity, CatalogSchemaTableName table) {
        this.delegate().checkCanCreateTable(identity, table);
    }

    public void checkCanDropTable(Identity identity, CatalogSchemaTableName table) {
        this.delegate().checkCanDropTable(identity, table);
    }

    public void checkCanRenameTable(Identity identity, CatalogSchemaTableName table, CatalogSchemaTableName newTable) {
        this.delegate().checkCanRenameTable(identity, table, newTable);
    }

    public void checkCanShowTablesMetadata(Identity identity, CatalogSchemaName schema) {
        this.delegate().checkCanShowTablesMetadata(identity, schema);
    }

    public Set<SchemaTableName> filterTables(Identity identity, String catalogName, Set<SchemaTableName> tableNames) {
        return this.delegate().filterTables(identity, catalogName, tableNames);
    }

    public void checkCanAddColumn(Identity identity, CatalogSchemaTableName table) {
        this.delegate().checkCanAddColumn(identity, table);
    }

    public void checkCanDropColumn(Identity identity, CatalogSchemaTableName table) {
        this.delegate().checkCanDropColumn(identity, table);
    }

    public void checkCanRenameColumn(Identity identity, CatalogSchemaTableName table) {
        this.delegate().checkCanRenameColumn(identity, table);
    }

    public void checkCanSelectFromColumns(Identity identity, CatalogSchemaTableName table, Set<String> columns) {
        this.delegate().checkCanSelectFromColumns(identity, table, columns);
    }

    public void checkCanInsertIntoTable(Identity identity, CatalogSchemaTableName table) {
        this.delegate().checkCanInsertIntoTable(identity, table);
    }

    public void checkCanDeleteFromTable(Identity identity, CatalogSchemaTableName table) {
        this.delegate().checkCanDeleteFromTable(identity, table);
    }

    public void checkCanCreateView(Identity identity, CatalogSchemaTableName view) {
        this.delegate().checkCanCreateView(identity, view);
    }

    public void checkCanDropView(Identity identity, CatalogSchemaTableName view) {
        this.delegate().checkCanDropView(identity, view);
    }

    public void checkCanCreateViewWithSelectFromColumns(Identity identity, CatalogSchemaTableName table, Set<String> columns) {
        this.delegate().checkCanCreateViewWithSelectFromColumns(identity, table, columns);
    }

    public void checkCanSetCatalogSessionProperty(Identity identity, String catalogName, String propertyName) {
        this.delegate().checkCanSetCatalogSessionProperty(identity, catalogName, propertyName);
    }

    public void checkCanGrantTablePrivilege(Identity identity, Privilege privilege, CatalogSchemaTableName table, String grantee, boolean withGrantOption) {
        this.delegate().checkCanGrantTablePrivilege(identity, privilege, table, grantee, withGrantOption);
    }

    public void checkCanRevokeTablePrivilege(Identity identity, Privilege privilege, CatalogSchemaTableName table, String revokee, boolean grantOptionFor) {
        this.delegate().checkCanRevokeTablePrivilege(identity, privilege, table, revokee, grantOptionFor);
    }
}

