/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.base.security;

import com.facebook.presto.plugin.base.security.AccessControlRules;
import com.facebook.presto.plugin.base.security.FileBasedAccessControlConfig;
import com.facebook.presto.plugin.base.security.SchemaAccessControlRule;
import com.facebook.presto.plugin.base.security.SessionPropertyAccessControlRule;
import com.facebook.presto.plugin.base.security.TableAccessControlRule;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.connector.ConnectorAccessControl;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.security.AccessDeniedException;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.security.Privilege;
import com.google.common.collect.ImmutableSet;
import io.airlift.json.JsonCodec;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;

public class FileBasedAccessControl
implements ConnectorAccessControl {
    private static final String INFORMATION_SCHEMA_NAME = "information_schema";
    private final List<SchemaAccessControlRule> schemaRules;
    private final List<TableAccessControlRule> tableRules;
    private final List<SessionPropertyAccessControlRule> sessionPropertyRules;

    @Inject
    public FileBasedAccessControl(FileBasedAccessControlConfig config, JsonCodec<AccessControlRules> codec) throws IOException {
        AccessControlRules rules = (AccessControlRules)codec.fromJson(Files.readAllBytes(Paths.get(config.getConfigFile(), new String[0])));
        this.schemaRules = rules.getSchemaRules();
        this.tableRules = rules.getTableRules();
        this.sessionPropertyRules = rules.getSessionPropertyRules();
    }

    public void checkCanShowSchemas(ConnectorTransactionHandle transactionHandle, Identity identity) {
    }

    public Set<String> filterSchemas(ConnectorTransactionHandle transactionHandle, Identity identity, Set<String> schemaNames) {
        return schemaNames;
    }

    public void checkCanCreateTable(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName tableName) {
        if (!this.isDatabaseOwner(identity, tableName.getSchemaName())) {
            AccessDeniedException.denyCreateTable((String)tableName.toString());
        }
    }

    public void checkCanDropTable(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName tableName) {
        if (!this.checkTablePermission(identity, tableName, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyDropTable((String)tableName.toString());
        }
    }

    public void checkCanShowTablesMetadata(ConnectorTransactionHandle transactionHandle, Identity identity, String schemaName) {
    }

    public Set<SchemaTableName> filterTables(ConnectorTransactionHandle transactionHandle, Identity identity, Set<SchemaTableName> tableNames) {
        return tableNames;
    }

    public void checkCanRenameTable(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName tableName, SchemaTableName newTableName) {
        if (!this.checkTablePermission(identity, tableName, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyRenameTable((String)tableName.toString(), (String)newTableName.toString());
        }
    }

    public void checkCanAddColumn(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName tableName) {
        if (!this.checkTablePermission(identity, tableName, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyAddColumn((String)tableName.toString());
        }
    }

    public void checkCanRenameColumn(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName tableName) {
        if (!this.checkTablePermission(identity, tableName, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyRenameColumn((String)tableName.toString());
        }
    }

    public void checkCanSelectFromTable(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName tableName) {
        if (!this.checkTablePermission(identity, tableName, TableAccessControlRule.TablePrivilege.SELECT)) {
            AccessDeniedException.denySelectTable((String)tableName.toString());
        }
    }

    public void checkCanInsertIntoTable(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName tableName) {
        if (!this.checkTablePermission(identity, tableName, TableAccessControlRule.TablePrivilege.INSERT)) {
            AccessDeniedException.denyInsertTable((String)tableName.toString());
        }
    }

    public void checkCanDeleteFromTable(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName tableName) {
        if (!this.checkTablePermission(identity, tableName, TableAccessControlRule.TablePrivilege.DELETE)) {
            AccessDeniedException.denyDeleteTable((String)tableName.toString());
        }
    }

    public void checkCanCreateView(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName viewName) {
        if (!this.isDatabaseOwner(identity, viewName.getSchemaName())) {
            AccessDeniedException.denyCreateView((String)viewName.toString());
        }
    }

    public void checkCanDropView(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName viewName) {
        if (!this.checkTablePermission(identity, viewName, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyDropView((String)viewName.toString());
        }
    }

    public void checkCanSelectFromView(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName viewName) {
        if (!this.checkTablePermission(identity, viewName, TableAccessControlRule.TablePrivilege.SELECT)) {
            AccessDeniedException.denySelectView((String)viewName.toString());
        }
    }

    public void checkCanCreateViewWithSelectFromTable(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName tableName) {
        if (!this.checkTablePermission(identity, tableName, TableAccessControlRule.TablePrivilege.SELECT)) {
            AccessDeniedException.denySelectTable((String)tableName.toString());
        }
    }

    public void checkCanCreateViewWithSelectFromView(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName viewName) {
        if (!this.checkTablePermission(identity, viewName, TableAccessControlRule.TablePrivilege.SELECT)) {
            AccessDeniedException.denySelectView((String)viewName.toString());
        }
        if (!this.checkTablePermission(identity, viewName, TableAccessControlRule.TablePrivilege.GRANT_SELECT)) {
            AccessDeniedException.denyCreateView((String)viewName.toString());
        }
    }

    public void checkCanSetCatalogSessionProperty(Identity identity, String propertyName) {
        if (!this.canSetSessionProperty(identity, propertyName)) {
            FileBasedAccessControl.denySetSessionProperty(propertyName);
        }
    }

    public void checkCanGrantTablePrivilege(ConnectorTransactionHandle transaction, Identity identity, Privilege privilege, SchemaTableName tableName, String grantee, boolean withGrantOption) {
        if (!this.checkTablePermission(identity, tableName, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyGrantTablePrivilege((String)privilege.name(), (String)tableName.toString());
        }
    }

    public void checkCanRevokeTablePrivilege(ConnectorTransactionHandle transaction, Identity identity, Privilege privilege, SchemaTableName tableName, String revokee, boolean grantOptionFor) {
        if (!this.checkTablePermission(identity, tableName, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyRevokeTablePrivilege((String)privilege.name(), (String)tableName.toString());
        }
    }

    private boolean canSetSessionProperty(Identity identity, String property) {
        for (SessionPropertyAccessControlRule rule : this.sessionPropertyRules) {
            Optional<Boolean> allowed = rule.match(identity.getUser(), property);
            if (allowed.isPresent() && allowed.get().booleanValue()) {
                return true;
            }
            if (!allowed.isPresent() || allowed.get().booleanValue()) continue;
            return false;
        }
        return false;
    }

    private boolean checkTablePermission(Identity identity, SchemaTableName tableName, TableAccessControlRule.TablePrivilege ... requiredPrivileges) {
        if (INFORMATION_SCHEMA_NAME.equals(tableName.getSchemaName())) {
            return true;
        }
        for (TableAccessControlRule rule : this.tableRules) {
            Optional<Set<TableAccessControlRule.TablePrivilege>> tablePrivileges = rule.match(identity.getUser(), tableName);
            if (!tablePrivileges.isPresent()) continue;
            return tablePrivileges.get().containsAll((Collection<?>)ImmutableSet.copyOf((Object[])requiredPrivileges));
        }
        return false;
    }

    private boolean isDatabaseOwner(Identity identity, String schemaName) {
        for (SchemaAccessControlRule rule : this.schemaRules) {
            Optional<Boolean> owner = rule.match(identity.getUser(), schemaName);
            if (!owner.isPresent()) continue;
            return owner.get();
        }
        return false;
    }

    private static void denySetSessionProperty(String propertyName) {
        throw new AccessDeniedException("Cannot set catalog session property: " + propertyName);
    }
}

