/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.base.security;

import com.facebook.presto.plugin.base.security.SchemaAccessControlRule;
import com.facebook.presto.plugin.base.security.SessionPropertyAccessControlRule;
import com.facebook.presto.plugin.base.security.TableAccessControlRule;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;

public class AccessControlRules {
    private final List<SchemaAccessControlRule> schemaRules;
    private final List<TableAccessControlRule> tableRules;
    private final List<SessionPropertyAccessControlRule> sessionPropertyRules;

    @JsonCreator
    public AccessControlRules(@JsonProperty(value="schemas") Optional<List<SchemaAccessControlRule>> schemaRules, @JsonProperty(value="tables") Optional<List<TableAccessControlRule>> tableRules, @JsonProperty(value="sessionProperties") Optional<List<SessionPropertyAccessControlRule>> sessionPropertyRules) {
        this.schemaRules = schemaRules.orElse((List<SchemaAccessControlRule>)ImmutableList.of());
        this.tableRules = tableRules.orElse((List<TableAccessControlRule>)ImmutableList.of());
        this.sessionPropertyRules = sessionPropertyRules.orElse((List<SessionPropertyAccessControlRule>)ImmutableList.of());
    }

    public List<SchemaAccessControlRule> getSchemaRules() {
        return this.schemaRules;
    }

    public List<TableAccessControlRule> getTableRules() {
        return this.tableRules;
    }

    public List<SessionPropertyAccessControlRule> getSessionPropertyRules() {
        return this.sessionPropertyRules;
    }
}

