/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.base.security;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;

public class SessionPropertyAccessControlRule {
    private final boolean allow;
    private final Optional<Pattern> userRegex;
    private final Optional<Pattern> propertyRegex;

    @JsonCreator
    public SessionPropertyAccessControlRule(@JsonProperty(value="allow") boolean allow, @JsonProperty(value="user") Optional<Pattern> userRegex, @JsonProperty(value="property") Optional<Pattern> propertyRegex) {
        this.allow = allow;
        this.userRegex = Objects.requireNonNull(userRegex, "userRegex is null");
        this.propertyRegex = Objects.requireNonNull(propertyRegex, "propertyRegex is null");
    }

    public Optional<Boolean> match(String user, String property) {
        if (this.userRegex.map(regex -> regex.matcher(user).matches()).orElse(true).booleanValue() && this.propertyRegex.map(regex -> regex.matcher(property).matches()).orElse(true).booleanValue()) {
            return Optional.of(this.allow);
        }
        return Optional.empty();
    }
}

