/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.WithQuery;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public class With
extends Node {
    private final boolean recursive;
    private final List<WithQuery> queries;

    public With(boolean recursive, List<WithQuery> queries) {
        Preconditions.checkNotNull(queries, (Object)"queries is null");
        Preconditions.checkArgument((!queries.isEmpty() ? 1 : 0) != 0, (Object)"queries is empty");
        this.recursive = recursive;
        this.queries = ImmutableList.copyOf(queries);
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public List<WithQuery> getQueries() {
        return this.queries;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitWith(this, context);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        With o = (With)obj;
        return Objects.equals(this.recursive, o.recursive) && Objects.equals(this.queries, o.queries);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.recursive, this.queries);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("recursive", this.recursive).add("queries", this.queries).toString();
    }
}

