/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql;

import com.facebook.presto.sql.tree.AliasedRelation;
import com.facebook.presto.sql.tree.AllColumns;
import com.facebook.presto.sql.tree.ArithmeticBinaryExpression;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.DefaultTraversalVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.LikePredicate;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.Row;
import com.facebook.presto.sql.tree.SampledRelation;
import com.facebook.presto.sql.tree.Select;
import com.facebook.presto.sql.tree.SingleColumn;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.sql.tree.StringLiteral;
import com.facebook.presto.sql.tree.SubqueryExpression;
import com.facebook.presto.sql.tree.Table;
import com.facebook.presto.sql.tree.TableSubquery;
import com.facebook.presto.sql.tree.Values;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.io.PrintStream;
import java.util.IdentityHashMap;
import java.util.Iterator;

public class TreePrinter {
    private static final String INDENT = "   ";
    private final IdentityHashMap<QualifiedNameReference, QualifiedName> resolvedNameReferences;
    private final PrintStream out;

    public TreePrinter(IdentityHashMap<QualifiedNameReference, QualifiedName> resolvedNameReferences, PrintStream out) {
        this.resolvedNameReferences = new IdentityHashMap<QualifiedNameReference, QualifiedName>(resolvedNameReferences);
        this.out = out;
    }

    public void print(Node root) {
        DefaultTraversalVisitor<Void, Integer> printer = new DefaultTraversalVisitor<Void, Integer>(){

            @Override
            protected Void visitNode(Node node, Integer indentLevel) {
                throw new UnsupportedOperationException("not yet implemented: " + node);
            }

            @Override
            protected Void visitQuery(Query node, Integer indentLevel) {
                TreePrinter.this.print(indentLevel, "Query ");
                Integer n = indentLevel;
                Integer n2 = indentLevel = Integer.valueOf(indentLevel + 1);
                TreePrinter.this.print(indentLevel, "QueryBody");
                this.process(node.getQueryBody(), indentLevel);
                if (!node.getOrderBy().isEmpty()) {
                    TreePrinter.this.print(indentLevel, "OrderBy");
                    for (SortItem sortItem : node.getOrderBy()) {
                        this.process(sortItem, indentLevel + 1);
                    }
                }
                if (node.getLimit().isPresent()) {
                    TreePrinter.this.print(indentLevel, "Limit: " + node.getLimit().get());
                }
                return null;
            }

            @Override
            protected Void visitQuerySpecification(QuerySpecification node, Integer indentLevel) {
                TreePrinter.this.print(indentLevel, "QuerySpecification ");
                Iterator<SortItem> iterator = indentLevel;
                Integer n = indentLevel = Integer.valueOf(indentLevel + 1);
                this.process(node.getSelect(), indentLevel);
                if (node.getFrom().isPresent()) {
                    TreePrinter.this.print(indentLevel, "From");
                    this.process(node.getFrom().get(), indentLevel + 1);
                }
                if (node.getWhere().isPresent()) {
                    TreePrinter.this.print(indentLevel, "Where");
                    this.process(node.getWhere().get(), indentLevel + 1);
                }
                if (!node.getGroupBy().isEmpty()) {
                    TreePrinter.this.print(indentLevel, "GroupBy");
                    for (Expression expression : node.getGroupBy()) {
                        this.process(expression, indentLevel + 1);
                    }
                }
                if (node.getHaving().isPresent()) {
                    TreePrinter.this.print(indentLevel, "Having");
                    this.process(node.getHaving().get(), indentLevel + 1);
                }
                if (!node.getOrderBy().isEmpty()) {
                    TreePrinter.this.print(indentLevel, "OrderBy");
                    for (SortItem sortItem : node.getOrderBy()) {
                        this.process(sortItem, indentLevel + 1);
                    }
                }
                if (node.getLimit().isPresent()) {
                    TreePrinter.this.print(indentLevel, "Limit: " + node.getLimit().get());
                }
                return null;
            }

            @Override
            protected Void visitSelect(Select node, Integer indentLevel) {
                String distinct = "";
                if (node.isDistinct()) {
                    distinct = "[DISTINCT]";
                }
                TreePrinter.this.print(indentLevel, "Select" + distinct);
                super.visitSelect(node, indentLevel + 1);
                return null;
            }

            @Override
            protected Void visitAllColumns(AllColumns node, Integer indent) {
                if (node.getPrefix().isPresent()) {
                    TreePrinter.this.print(indent, node.getPrefix() + ".*");
                } else {
                    TreePrinter.this.print(indent, "*");
                }
                return null;
            }

            @Override
            protected Void visitSingleColumn(SingleColumn node, Integer indent) {
                if (node.getAlias().isPresent()) {
                    TreePrinter.this.print(indent, "Alias: " + node.getAlias().get());
                }
                super.visitSingleColumn(node, indent + 1);
                return null;
            }

            @Override
            protected Void visitComparisonExpression(ComparisonExpression node, Integer indentLevel) {
                TreePrinter.this.print(indentLevel, node.getType().toString());
                super.visitComparisonExpression(node, indentLevel + 1);
                return null;
            }

            @Override
            protected Void visitArithmeticBinary(ArithmeticBinaryExpression node, Integer indentLevel) {
                TreePrinter.this.print(indentLevel, node.getType().toString());
                super.visitArithmeticBinary(node, indentLevel + 1);
                return null;
            }

            @Override
            protected Void visitLogicalBinaryExpression(LogicalBinaryExpression node, Integer indentLevel) {
                TreePrinter.this.print(indentLevel, node.getType().toString());
                super.visitLogicalBinaryExpression(node, indentLevel + 1);
                return null;
            }

            @Override
            protected Void visitStringLiteral(StringLiteral node, Integer indentLevel) {
                TreePrinter.this.print(indentLevel, "String[" + node.getValue() + "]");
                return null;
            }

            @Override
            protected Void visitBooleanLiteral(BooleanLiteral node, Integer indentLevel) {
                TreePrinter.this.print(indentLevel, "Boolean[" + node.getValue() + "]");
                return null;
            }

            @Override
            protected Void visitLongLiteral(LongLiteral node, Integer indentLevel) {
                TreePrinter.this.print(indentLevel, "Long[" + node.getValue() + "]");
                return null;
            }

            @Override
            protected Void visitLikePredicate(LikePredicate node, Integer indentLevel) {
                TreePrinter.this.print(indentLevel, "LIKE");
                super.visitLikePredicate(node, indentLevel + 1);
                return null;
            }

            @Override
            protected Void visitQualifiedNameReference(QualifiedNameReference node, Integer indentLevel) {
                QualifiedName resolved = (QualifiedName)TreePrinter.this.resolvedNameReferences.get(node);
                String resolvedName = "";
                if (resolved != null) {
                    resolvedName = "=>" + resolved.toString();
                }
                TreePrinter.this.print(indentLevel, "QualifiedName[" + node.getName() + resolvedName + "]");
                return null;
            }

            @Override
            protected Void visitFunctionCall(FunctionCall node, Integer indentLevel) {
                String name = Joiner.on((char)'.').join(node.getName().getParts());
                TreePrinter.this.print(indentLevel, "FunctionCall[" + name + "]");
                super.visitFunctionCall(node, indentLevel + 1);
                return null;
            }

            @Override
            protected Void visitTable(Table node, Integer indentLevel) {
                String name = Joiner.on((char)'.').join(node.getName().getParts());
                TreePrinter.this.print(indentLevel, "Table[" + name + "]");
                return null;
            }

            @Override
            protected Void visitValues(Values node, Integer indentLevel) {
                TreePrinter.this.print(indentLevel, "Values");
                super.visitValues(node, indentLevel + 1);
                return null;
            }

            @Override
            protected Void visitRow(Row node, Integer indentLevel) {
                TreePrinter.this.print(indentLevel, "Row");
                super.visitRow(node, indentLevel + 1);
                return null;
            }

            @Override
            protected Void visitAliasedRelation(AliasedRelation node, Integer indentLevel) {
                TreePrinter.this.print(indentLevel, "Alias[" + node.getAlias() + "]");
                super.visitAliasedRelation(node, indentLevel + 1);
                return null;
            }

            @Override
            protected Void visitSampledRelation(SampledRelation node, Integer indentLevel) {
                String stratifyOn = "";
                if (node.getColumnsToStratifyOn().isPresent()) {
                    stratifyOn = " STRATIFY ON (" + node.getColumnsToStratifyOn().get().toString() + ")";
                }
                TreePrinter.this.print(indentLevel, "TABLESAMPLE[" + (Object)((Object)node.getType()) + " (" + node.getSamplePercentage() + ")" + stratifyOn + "]");
                super.visitSampledRelation(node, indentLevel + 1);
                return null;
            }

            @Override
            protected Void visitTableSubquery(TableSubquery node, Integer indentLevel) {
                TreePrinter.this.print(indentLevel, "SubQuery");
                super.visitTableSubquery(node, indentLevel + 1);
                return null;
            }

            @Override
            protected Void visitInPredicate(InPredicate node, Integer indentLevel) {
                TreePrinter.this.print(indentLevel, "IN");
                super.visitInPredicate(node, indentLevel + 1);
                return null;
            }

            @Override
            protected Void visitSubqueryExpression(SubqueryExpression node, Integer indentLevel) {
                TreePrinter.this.print(indentLevel, "SubQuery");
                super.visitSubqueryExpression(node, indentLevel + 1);
                return null;
            }
        };
        printer.process(root, 0);
    }

    private void print(Integer indentLevel, String value) {
        this.out.println(Strings.repeat((String)INDENT, (int)indentLevel) + value);
    }
}

