/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ShowPartitions
extends Statement {
    private final QualifiedName table;
    private final Optional<Expression> where;
    private final List<SortItem> orderBy;
    private final Optional<String> limit;

    public ShowPartitions(QualifiedName table, Optional<Expression> where, List<SortItem> orderBy, Optional<String> limit) {
        this.table = (QualifiedName)Preconditions.checkNotNull((Object)table, (Object)"table is null");
        this.where = (Optional)Preconditions.checkNotNull(where, (Object)"where is null");
        this.orderBy = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(orderBy, (Object)"orderBy is null")));
        this.limit = (Optional)Preconditions.checkNotNull(limit, (Object)"limit is null");
    }

    public QualifiedName getTable() {
        return this.table;
    }

    public Optional<Expression> getWhere() {
        return this.where;
    }

    public List<SortItem> getOrderBy() {
        return this.orderBy;
    }

    public Optional<String> getLimit() {
        return this.limit;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitShowPartitions(this, context);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.table, this.where, this.orderBy, this.limit);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ShowPartitions o = (ShowPartitions)obj;
        return Objects.equals(this.table, o.table) && Objects.equals(this.where, o.where) && Objects.equals(this.orderBy, o.orderBy) && Objects.equals(this.limit, o.limit);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("table", (Object)this.table).add("where", this.where).add("orderBy", this.orderBy).add("limit", this.limit).toString();
    }
}

