/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;

public class CreateView
extends Statement {
    private final QualifiedName name;
    private final Query query;
    private final boolean replace;

    public CreateView(QualifiedName name, Query query, boolean replace) {
        this.name = (QualifiedName)Preconditions.checkNotNull((Object)name, (Object)"name is null");
        this.query = (Query)Preconditions.checkNotNull((Object)query, (Object)"query is null");
        this.replace = replace;
    }

    public QualifiedName getName() {
        return this.name;
    }

    public Query getQuery() {
        return this.query;
    }

    public boolean isReplace() {
        return this.replace;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCreateView(this, context);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.query, this.replace);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CreateView o = (CreateView)obj;
        return Objects.equals(this.name, o.name) && Objects.equals(this.query, o.query) && Objects.equals(this.replace, o.replace);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("query", (Object)this.query).add("replace", this.replace).toString();
    }
}

