/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Relation;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.List;

public class AliasedRelation
extends Relation {
    private final Relation relation;
    private final String alias;
    private final List<String> columnNames;

    public AliasedRelation(Relation relation, String alias, List<String> columnNames) {
        Preconditions.checkNotNull((Object)relation, (Object)"relation is null");
        Preconditions.checkNotNull((Object)alias, (Object)" is null");
        this.relation = relation;
        this.alias = alias;
        this.columnNames = columnNames;
    }

    public Relation getRelation() {
        return this.relation;
    }

    public String getAlias() {
        return this.alias;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitAliasedRelation(this, context);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("relation", (Object)this.relation).add("alias", (Object)this.alias).add("columnNames", this.columnNames).omitNullValues().toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AliasedRelation that = (AliasedRelation)o;
        if (!this.alias.equals(that.alias)) {
            return false;
        }
        if (this.columnNames != null ? !this.columnNames.equals(that.columnNames) : that.columnNames != null) {
            return false;
        }
        return this.relation.equals(that.relation);
    }

    @Override
    public int hashCode() {
        int result = this.relation.hashCode();
        result = 31 * result + this.alias.hashCode();
        result = 31 * result + (this.columnNames != null ? this.columnNames.hashCode() : 0);
        return result;
    }

    public static Function<QualifiedName, QualifiedName> applyAlias(final AliasedRelation node) {
        return new Function<QualifiedName, QualifiedName>(){

            public QualifiedName apply(QualifiedName input) {
                return QualifiedName.of(node.getAlias(), input.getSuffix());
            }
        };
    }
}

