/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Literal;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Locale;

public class BooleanLiteral
extends Literal {
    public static final BooleanLiteral TRUE_LITERAL = new BooleanLiteral("true");
    public static final BooleanLiteral FALSE_LITERAL = new BooleanLiteral("false");
    private final boolean value;

    public BooleanLiteral(String value) {
        Preconditions.checkNotNull((Object)value, (Object)"value is null");
        Preconditions.checkArgument((value.toLowerCase(Locale.ENGLISH).equals("true") || value.toLowerCase(Locale.ENGLISH).equals("false") ? 1 : 0) != 0);
        this.value = value.toLowerCase(Locale.ENGLISH).equals("true");
    }

    public boolean getValue() {
        return this.value;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitBooleanLiteral(this, context);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.value});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BooleanLiteral other = (BooleanLiteral)obj;
        return Objects.equal((Object)this.value, (Object)other.value);
    }
}

