/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.parser;

import com.facebook.presto.sql.parser.IdentifierSymbol;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.EnumSet;

public class SqlParserOptions {
    private EnumSet<IdentifierSymbol> allowedIdentifierSymbols = EnumSet.noneOf(IdentifierSymbol.class);

    public SqlParserOptions allowIdentifierSymbol(Iterable<IdentifierSymbol> identifierSymbols) {
        Iterables.addAll(this.allowedIdentifierSymbols, identifierSymbols);
        return this;
    }

    public EnumSet<IdentifierSymbol> getAllowedIdentifierSymbols() {
        return EnumSet.copyOf(this.allowedIdentifierSymbols);
    }

    public SqlParserOptions allowIdentifierSymbol(IdentifierSymbol ... identifierSymbols) {
        for (IdentifierSymbol identifierSymbol : identifierSymbols) {
            this.allowedIdentifierSymbols.add((IdentifierSymbol)((Object)Preconditions.checkNotNull((Object)((Object)identifierSymbol), (Object)"identifierSymbol is null")));
        }
        return this;
    }
}

