/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Relation;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;

public class SampledRelation
extends Relation {
    private final Relation relation;
    private final Type type;
    private final Expression samplePercentage;
    private final boolean rescaled;
    private final Optional<List<Expression>> columnsToStratifyOn;

    public SampledRelation(Relation relation, Type type, Expression samplePercentage, boolean rescaled, Optional<List<Expression>> columnsToStratifyOn) {
        this.relation = (Relation)Preconditions.checkNotNull((Object)relation, (Object)"relation is null");
        this.type = (Type)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"type is null"));
        this.samplePercentage = (Expression)Preconditions.checkNotNull((Object)samplePercentage, (Object)"samplePercentage is null");
        this.rescaled = rescaled;
        this.columnsToStratifyOn = columnsToStratifyOn.isPresent() ? Optional.of((Object)ImmutableList.copyOf((Collection)((Collection)columnsToStratifyOn.get()))) : columnsToStratifyOn;
    }

    public Relation getRelation() {
        return this.relation;
    }

    public Type getType() {
        return this.type;
    }

    public Expression getSamplePercentage() {
        return this.samplePercentage;
    }

    public boolean isRescaled() {
        return this.rescaled;
    }

    public Optional<List<Expression>> getColumnsToStratifyOn() {
        return this.columnsToStratifyOn;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitSampledRelation(this, context);
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).add("relation", (Object)this.relation).add("type", (Object)this.type).add("samplePercentage", (Object)this.samplePercentage).add("columnsToStratifyOn", this.columnsToStratifyOn).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SampledRelation that = (SampledRelation)o;
        return Objects.equal((Object)this.relation, (Object)that.relation) && Objects.equal((Object)((Object)this.type), (Object)((Object)that.type)) && Objects.equal((Object)this.samplePercentage, (Object)that.samplePercentage) && Objects.equal(this.columnsToStratifyOn, that.columnsToStratifyOn);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.relation, this.type, this.samplePercentage, this.columnsToStratifyOn});
    }

    public static enum Type {
        BERNOULLI,
        POISSONIZED,
        SYSTEM;

    }
}

