/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.testing;

import com.facebook.presto.sql.SqlFormatter;
import com.facebook.presto.sql.parser.ParsingException;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.tree.DefaultTraversalVisitor;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;

public final class TreeAssertions {
    private TreeAssertions() {
    }

    public static void assertFormattedSql(Node expected) {
        String formatted = SqlFormatter.formatSql(expected);
        Statement actual = TreeAssertions.parseFormatted(formatted, expected);
        TreeAssertions.assertEquals(SqlFormatter.formatSql(actual), formatted);
        if (!actual.equals(expected)) {
            TreeAssertions.assertListEquals(TreeAssertions.linearizeTree(actual), TreeAssertions.linearizeTree(expected));
        }
        TreeAssertions.assertEquals(actual, expected);
    }

    private static Statement parseFormatted(String sql, Node tree) {
        try {
            return SqlParser.createStatement(sql);
        }
        catch (ParsingException e) {
            throw new AssertionError((Object)String.format("failed to parse formatted SQL: %s\nerror: %s\ntree: %s", sql, e.getMessage(), tree));
        }
    }

    private static List<Node> linearizeTree(Node tree) {
        final ImmutableList.Builder nodes = ImmutableList.builder();
        new DefaultTraversalVisitor<Node, Void>(){

            @Override
            public Node process(Node node, @Nullable Void context) {
                Node result = (Node)super.process(node, context);
                nodes.add((Object)node);
                return result;
            }
        }.process(tree, (Void)null);
        return nodes.build();
    }

    private static <T> void assertListEquals(List<T> actual, List<T> expected) {
        if (actual.size() != expected.size()) {
            Joiner joiner = Joiner.on((String)"\n    ");
            throw new AssertionError((Object)String.format("Lists not equal%nActual [%s]:%n    %s%nExpected [%s]:%n    %s%n", actual.size(), joiner.join(actual), expected.size(), joiner.join(expected)));
        }
        TreeAssertions.assertEquals(actual, expected);
    }

    private static <T> void assertEquals(T actual, T expected) {
        if (!actual.equals(expected)) {
            throw new AssertionError((Object)String.format("expected [%s] but found [%s]", expected, actual));
        }
    }
}

