/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Window;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import java.util.List;

public class FunctionCall
extends Expression {
    private final QualifiedName name;
    private final Optional<Window> window;
    private final boolean distinct;
    private final List<Expression> arguments;

    public FunctionCall(QualifiedName name, List<Expression> arguments) {
        this(name, null, false, arguments);
    }

    public FunctionCall(QualifiedName name, Window window, boolean distinct, List<Expression> arguments) {
        this.name = name;
        this.window = Optional.fromNullable((Object)window);
        this.distinct = distinct;
        this.arguments = arguments;
    }

    public QualifiedName getName() {
        return this.name;
    }

    public Optional<Window> getWindow() {
        return this.window;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public List<Expression> getArguments() {
        return this.arguments;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitFunctionCall(this, context);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionCall o = (FunctionCall)obj;
        return Objects.equal((Object)this.name, (Object)o.name) && Objects.equal(this.window, o.window) && Objects.equal((Object)this.distinct, (Object)o.distinct) && Objects.equal(this.arguments, o.arguments);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.distinct, this.window, this.arguments});
    }

    public static Function<FunctionCall, List<Expression>> argumentsGetter() {
        return new Function<FunctionCall, List<Expression>>(){

            public List<Expression> apply(FunctionCall input) {
                return input.getArguments();
            }
        };
    }

    public static Predicate<FunctionCall> distinctPredicate() {
        return new Predicate<FunctionCall>(){

            public boolean apply(FunctionCall input) {
                return input.isDistinct();
            }
        };
    }
}

