/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Literal;
import com.google.common.base.Preconditions;

public class IntervalLiteral
extends Literal {
    private final String value;
    private final String type;
    private final Sign sign;
    private final long seconds;
    private final long months;
    private final boolean yearToMonth;

    public IntervalLiteral(String value, String type, Sign sign) {
        Preconditions.checkNotNull((Object)value, (Object)"value is null");
        Preconditions.checkNotNull((Object)type, (Object)"type is null");
        this.value = value;
        this.type = type;
        this.sign = sign;
        int signValue = sign == Sign.POSITIVE ? 1 : -1;
        switch (type.toUpperCase()) {
            case "YEAR": {
                this.months = (long)signValue * Long.parseLong(value) * 12L;
                this.seconds = 0L;
                this.yearToMonth = true;
                break;
            }
            case "MONTH": {
                this.months = (long)signValue * Long.parseLong(value);
                this.seconds = 0L;
                this.yearToMonth = true;
                break;
            }
            case "DAY": {
                this.months = 0L;
                this.seconds = (long)signValue * Long.parseLong(value) * 60L * 60L * 24L;
                this.yearToMonth = false;
                break;
            }
            case "HOUR": {
                this.months = 0L;
                this.seconds = (long)signValue * Long.parseLong(value) * 60L * 60L;
                this.yearToMonth = false;
                break;
            }
            case "MINUTE": {
                this.months = 0L;
                this.seconds = (long)signValue * Long.parseLong(value) * 60L;
                this.yearToMonth = false;
                break;
            }
            case "SECOND": {
                this.months = 0L;
                this.seconds = (long)signValue * Long.parseLong(value);
                this.yearToMonth = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported INTERVAL type " + type);
            }
        }
    }

    public String getValue() {
        return this.value;
    }

    public String getType() {
        return this.type;
    }

    public Sign getSign() {
        return this.sign;
    }

    public long getMonths() {
        return this.months;
    }

    public long getSeconds() {
        return this.seconds;
    }

    public boolean isYearToMonth() {
        return this.yearToMonth;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitIntervalLiteral(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntervalLiteral that = (IntervalLiteral)o;
        if (this.sign != that.sign) {
            return false;
        }
        if (!this.type.equals(that.type)) {
            return false;
        }
        return this.value.equals(that.value);
    }

    @Override
    public int hashCode() {
        int result = this.value.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + (this.sign != null ? this.sign.hashCode() : 0);
        return result;
    }

    public static enum Sign {
        POSITIVE,
        NEGATIVE;

    }
}

