/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.parser;

import com.facebook.presto.sql.parser.CaseInsensitiveStream;
import com.facebook.presto.sql.parser.ParsingException;
import com.facebook.presto.sql.parser.StatementLexer;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;

public class StatementSplitter {
    private final List<Statement> completeStatements;
    private final String partialStatement;

    public StatementSplitter(String sql) {
        this(sql, (Set<String>)ImmutableSet.of((Object)";"));
    }

    public StatementSplitter(String sql, Set<String> delimiters) {
        Token token;
        TokenSource tokens = StatementSplitter.getLexer(sql, delimiters);
        ImmutableList.Builder list = ImmutableList.builder();
        StringBuilder sb = new StringBuilder();
        while ((token = tokens.nextToken()).getType() != -1) {
            if (token.getType() == 178) {
                String statement = sb.toString().trim();
                if (!statement.isEmpty()) {
                    list.add((Object)new Statement(statement, token.getText()));
                }
                sb = new StringBuilder();
                continue;
            }
            sb.append(StatementSplitter.getTokenText(token));
        }
        this.completeStatements = list.build();
        this.partialStatement = sb.toString().trim();
    }

    public List<Statement> getCompleteStatements() {
        return this.completeStatements;
    }

    public String getPartialStatement() {
        return this.partialStatement;
    }

    public static String squeezeStatement(String sql) {
        TokenSource tokens = StatementSplitter.getLexer(sql, (Set<String>)ImmutableSet.of());
        StringBuilder sb = new StringBuilder();
        int index = 0;
        while (true) {
            Token token;
            try {
                token = tokens.nextToken();
                index = ((CommonToken)token).getStopIndex() + 1;
            }
            catch (ParsingException e) {
                sb.append(sql.substring(index));
                break;
            }
            if (token.getType() == -1) break;
            if (token.getType() == 202) {
                sb.append(' ');
                continue;
            }
            sb.append(StatementSplitter.getTokenText(token));
        }
        return sb.toString().trim();
    }

    private static String getTokenText(Token token) {
        switch (token.getType()) {
            case 169: {
                return "'" + token.getText().replace("'", "''") + "'";
            }
            case 140: {
                return "\"" + token.getText().replace("\"", "\"\"") + "\"";
            }
            case 13: {
                return "`" + token.getText().replace("`", "``") + "`";
            }
        }
        return token.getText();
    }

    private static TokenSource getLexer(String sql, Set<String> terminators) {
        Preconditions.checkNotNull((Object)sql, (Object)"sql is null");
        CaseInsensitiveStream stream = new CaseInsensitiveStream((CharStream)new ANTLRStringStream(sql));
        return new ErrorHandlingLexer((CharStream)stream, terminators);
    }

    public static class Statement {
        private final String statement;
        private final String terminator;

        public Statement(String statement, String terminator) {
            this.statement = (String)Preconditions.checkNotNull((Object)statement, (Object)"statement is null");
            this.terminator = (String)Preconditions.checkNotNull((Object)terminator, (Object)"terminator is null");
        }

        public String statement() {
            return this.statement;
        }

        public String terminator() {
            return this.terminator;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Statement o = (Statement)obj;
            return Objects.equal((Object)this.statement, (Object)o.statement) && Objects.equal((Object)this.terminator, (Object)o.terminator);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.statement, this.terminator});
        }

        public String toString() {
            return this.statement + this.terminator;
        }
    }

    private static class ErrorHandlingLexer
    extends StatementLexer {
        private final Set<String> terminators;

        public ErrorHandlingLexer(CharStream input, Set<String> terminators) {
            super(input);
            this.terminators = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(terminators, (Object)"terminators is null")));
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Token nextToken() {
            while (true) {
                this.state.token = null;
                this.state.channel = 0;
                this.state.tokenStartCharIndex = this.input.index();
                this.state.tokenStartCharPositionInLine = this.input.getCharPositionInLine();
                this.state.tokenStartLine = this.input.getLine();
                this.state.text = null;
                if (this.input.LA(1) == -1) {
                    CommonToken eof = new CommonToken(this.input, -1, 0, this.input.index(), this.input.index());
                    eof.setLine(this.getLine());
                    eof.setCharPositionInLine(this.getCharPositionInLine());
                    return eof;
                }
                for (String terminator : this.terminators) {
                    if (!this.matches(terminator)) continue;
                    this.state.type = 178;
                    this.emit();
                    return this.state.token;
                }
                try {
                    this.mTokens();
                    if (this.state.token == null) {
                        this.emit();
                        return this.state.token;
                    }
                    if (this.state.token != Token.SKIP_TOKEN) return this.state.token;
                }
                catch (RecognitionException re) {
                    this.input.consume();
                    this.state.type = 107;
                    this.emit();
                    return this.state.token;
                }
            }
        }

        private boolean matches(String s) {
            int i;
            for (i = 0; i < s.length(); ++i) {
                if (this.input.LA(i + 1) == s.charAt(i)) continue;
                return false;
            }
            for (i = 0; i < s.length(); ++i) {
                this.input.consume();
            }
            return true;
        }
    }
}

