/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.parser;

import com.facebook.presto.sql.parser.CaseInsensitiveStream;
import com.facebook.presto.sql.parser.ParsingException;
import com.facebook.presto.sql.parser.StatementBuilder;
import com.facebook.presto.sql.parser.StatementLexer;
import com.facebook.presto.sql.parser.StatementParser;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.annotations.VisibleForTesting;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.BufferedTreeNodeStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.TreeNodeStream;

public final class SqlParser {
    private SqlParser() {
    }

    public static Statement createStatement(String sql) {
        try {
            return SqlParser.createStatement(SqlParser.parseStatement(sql));
        }
        catch (StackOverflowError e) {
            throw new ParsingException("statement is too large (stack overflow while parsing)");
        }
    }

    public static Expression createExpression(String expression) {
        try {
            return SqlParser.createExpression(SqlParser.parseExpression(expression));
        }
        catch (StackOverflowError e) {
            throw new ParsingException("expression is too large (stack overflow while parsing)");
        }
    }

    @VisibleForTesting
    static Statement createStatement(CommonTree tree) {
        BufferedTreeNodeStream stream = new BufferedTreeNodeStream((Object)tree);
        StatementBuilder builder = new StatementBuilder((TreeNodeStream)stream);
        try {
            return builder.statement().value;
        }
        catch (RecognitionException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static Expression createExpression(CommonTree tree) {
        BufferedTreeNodeStream stream = new BufferedTreeNodeStream((Object)tree);
        StatementBuilder builder = new StatementBuilder((TreeNodeStream)stream);
        try {
            return builder.singleExpression().value;
        }
        catch (RecognitionException e) {
            throw new AssertionError((Object)e);
        }
    }

    @VisibleForTesting
    static CommonTree parseStatement(String sql) {
        try {
            return (CommonTree)SqlParser.getParser(sql).singleStatement().getTree();
        }
        catch (RecognitionException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static CommonTree parseExpression(String expression) {
        try {
            return (CommonTree)SqlParser.getParser(expression).singleExpression().getTree();
        }
        catch (RecognitionException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static StatementParser getParser(String sql) {
        CaseInsensitiveStream stream = new CaseInsensitiveStream((CharStream)new ANTLRStringStream(sql));
        StatementLexer lexer = new StatementLexer(stream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        return new StatementParser((TokenStream)tokenStream);
    }
}

