/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Literal;
import com.google.common.base.Preconditions;

public class LongLiteral
extends Literal {
    private final long value;

    public LongLiteral(String value) {
        Preconditions.checkNotNull((Object)value, (Object)"value is null");
        this.value = Long.parseLong(value);
    }

    public long getValue() {
        return this.value;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitLongLiteral(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LongLiteral that = (LongLiteral)o;
        return this.value == that.value;
    }

    @Override
    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }
}

