/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.QueryBody;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.sql.tree.With;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.List;

public class Query
extends Statement {
    private final Optional<With> with;
    private final QueryBody queryBody;
    private final List<SortItem> orderBy;
    private final Optional<String> limit;

    public Query(Optional<With> with, QueryBody queryBody, List<SortItem> orderBy, Optional<String> limit) {
        Preconditions.checkNotNull(with, (Object)"with is null");
        Preconditions.checkNotNull((Object)queryBody, (Object)"queryBody is null");
        Preconditions.checkNotNull(orderBy, (Object)"orderBy is null");
        Preconditions.checkNotNull(limit, (Object)"limit is null");
        this.with = with;
        this.queryBody = queryBody;
        this.orderBy = orderBy;
        this.limit = limit;
    }

    public Optional<With> getWith() {
        return this.with;
    }

    public QueryBody getQueryBody() {
        return this.queryBody;
    }

    public List<SortItem> getOrderBy() {
        return this.orderBy;
    }

    public Optional<String> getLimit() {
        return this.limit;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitQuery(this, context);
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).add("with", this.with.orNull()).add("queryBody", (Object)this.queryBody).add("orderBy", this.orderBy).add("limit", this.limit.orNull()).omitNullValues().toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Query o = (Query)obj;
        return Objects.equal(this.with, o.with) && Objects.equal((Object)this.queryBody, (Object)o.queryBody) && Objects.equal(this.orderBy, o.orderBy) && Objects.equal(this.limit, o.limit);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.with, this.queryBody, this.orderBy, this.limit});
    }
}

