/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.google.common.base.Preconditions;

public class CurrentTime
extends Expression {
    private final Type type;
    private final Integer precision;

    public CurrentTime(Type type) {
        this(type, null);
    }

    public CurrentTime(Type type, Integer precision) {
        Preconditions.checkNotNull((Object)((Object)type), (Object)"type is null");
        this.type = type;
        this.precision = precision;
    }

    public Type getType() {
        return this.type;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCurrentTime(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CurrentTime that = (CurrentTime)o;
        if (this.precision != null ? !this.precision.equals(that.precision) : that.precision != null) {
            return false;
        }
        return this.type == that.type;
    }

    @Override
    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + (this.precision != null ? this.precision.hashCode() : 0);
        return result;
    }

    public static enum Type {
        TIME("current_time"),
        DATE("current_date"),
        TIMESTAMP("current_timestamp");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

