/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class CoalesceExpression
extends Expression {
    private final List<Expression> operands;

    public CoalesceExpression(Expression ... operands) {
        this((List<Expression>)ImmutableList.copyOf((Object[])operands));
    }

    public CoalesceExpression(List<Expression> operands) {
        Preconditions.checkNotNull(operands, (Object)"operands is null");
        Preconditions.checkArgument((!operands.isEmpty() ? 1 : 0) != 0, (Object)"operands is empty");
        this.operands = ImmutableList.copyOf(operands);
    }

    public List<Expression> getOperands() {
        return this.operands;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCoalesceExpression(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoalesceExpression that = (CoalesceExpression)o;
        return this.operands.equals(that.operands);
    }

    @Override
    public int hashCode() {
        return this.operands.hashCode();
    }
}

