/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.google.common.base.Preconditions;

public class BetweenPredicate
extends Expression {
    private final Expression value;
    private final Expression min;
    private final Expression max;

    public BetweenPredicate(Expression value, Expression min, Expression max) {
        Preconditions.checkNotNull((Object)value, (Object)"value is null");
        Preconditions.checkNotNull((Object)min, (Object)"min is null");
        Preconditions.checkNotNull((Object)max, (Object)"max is null");
        this.value = value;
        this.min = min;
        this.max = max;
    }

    public Expression getValue() {
        return this.value;
    }

    public Expression getMin() {
        return this.min;
    }

    public Expression getMax() {
        return this.max;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitBetweenPredicate(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BetweenPredicate that = (BetweenPredicate)o;
        if (!this.max.equals(that.max)) {
            return false;
        }
        if (!this.min.equals(that.min)) {
            return false;
        }
        return this.value.equals(that.value);
    }

    @Override
    public int hashCode() {
        int result = this.value.hashCode();
        result = 31 * result + this.min.hashCode();
        result = 31 * result + this.max.hashCode();
        return result;
    }
}

