/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.ExplainOption;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class Explain
extends Statement {
    private final Query query;
    private final List<ExplainOption> options;

    public Explain(Query query, List<ExplainOption> options) {
        this.query = (Query)Preconditions.checkNotNull((Object)query, (Object)"query is null");
        this.options = options == null ? ImmutableList.of() : ImmutableList.copyOf(options);
    }

    public Query getQuery() {
        return this.query;
    }

    public List<ExplainOption> getOptions() {
        return this.options;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitExplain(this, context);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.query, this.options});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Explain o = (Explain)obj;
        return Objects.equal((Object)this.query, (Object)o.query) && Objects.equal(this.options, o.options);
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).add("query", (Object)this.query).add("options", this.options).toString();
    }
}

