/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Relation;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class SampledRelation
extends Relation {
    private final Relation relation;
    private final Type type;
    private final Expression samplePercentage;

    public SampledRelation(Relation relation, Type type, Expression samplePercentage) {
        this.relation = (Relation)Preconditions.checkNotNull((Object)relation, (Object)"relation is null");
        this.type = (Type)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"type is null"));
        this.samplePercentage = (Expression)Preconditions.checkNotNull((Object)samplePercentage, (Object)"samplePercentage is null");
    }

    public Relation getRelation() {
        return this.relation;
    }

    public Type getType() {
        return this.type;
    }

    public Expression getSamplePercentage() {
        return this.samplePercentage;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitSampledRelation(this, context);
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).add("relation", (Object)this.relation).add("type", (Object)this.type).add("samplePercentage", (Object)this.samplePercentage).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SampledRelation that = (SampledRelation)o;
        return Objects.equal((Object)this.relation, (Object)that.relation) && Objects.equal((Object)((Object)this.type), (Object)((Object)that.type)) && Objects.equal((Object)this.samplePercentage, (Object)that.samplePercentage);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.relation, this.type, this.samplePercentage});
    }

    public static enum Type {
        BERNOULLI,
        SYSTEM;

    }
}

