/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public abstract class Node {
    private final Optional<NodeLocation> location;

    protected Node(Optional<NodeLocation> location) {
        this.location = Objects.requireNonNull(location, "location is null");
    }

    protected <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitNode(this, context);
    }

    public Optional<NodeLocation> getLocation() {
        return this.location;
    }

    public String getArgumentTypeString() {
        throw new IllegalArgumentException("Unexpected table function argument type: " + this.getClass().getSimpleName());
    }

    public abstract List<? extends Node> getChildren();

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public abstract String toString();
}

