/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.MergeCase;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class MergeUpdate
extends MergeCase {
    private final List<Assignment> assignments;

    public MergeUpdate(List<Assignment> assignments) {
        this(Optional.empty(), assignments);
    }

    public MergeUpdate(NodeLocation location, List<Assignment> assignments) {
        this(Optional.of(location), assignments);
    }

    public MergeUpdate(Optional<NodeLocation> location, List<Assignment> assignments) {
        super(location);
        this.assignments = ImmutableList.copyOf((Collection)Objects.requireNonNull(assignments, "assignments is null"));
    }

    public List<Assignment> getAssignments() {
        return this.assignments;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitMergeUpdate(this, context);
    }

    @Override
    public List<Identifier> getSetColumns() {
        return (List)this.assignments.stream().map(Assignment::getTarget).collect(ImmutableList.toImmutableList());
    }

    @Override
    public List<Expression> getSetExpressions() {
        return (List)this.assignments.stream().map(Assignment::getValue).collect(ImmutableList.toImmutableList());
    }

    @Override
    public List<? extends Node> getChildren() {
        ImmutableList.Builder builder = ImmutableList.builder();
        this.assignments.forEach(assignment -> {
            builder.add((Object)assignment.getTarget());
            builder.add((Object)assignment.getValue());
        });
        return builder.build();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.assignments);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MergeUpdate o = (MergeUpdate)obj;
        return Objects.equals(this.assignments, o.assignments);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("assignments", this.assignments).omitNullValues().toString();
    }

    public static class Assignment {
        private final Identifier target;
        private final Expression value;

        public Assignment(Identifier target, Expression value) {
            this.target = Objects.requireNonNull(target, "target is null");
            this.value = Objects.requireNonNull(value, "value is null");
        }

        public Identifier getTarget() {
            return this.target;
        }

        public Expression getValue() {
            return this.value;
        }

        public int hashCode() {
            return Objects.hash(this.target, this.value);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Assignment o = (Assignment)obj;
            return Objects.equals(this.target, o.target) && Objects.equals(this.value, o.value);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("target", (Object)this.target).add("value", (Object)this.value).toString();
        }
    }
}

