/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.LambdaArgumentDeclaration;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class LambdaExpression
extends Expression {
    private final List<LambdaArgumentDeclaration> arguments;
    private final Expression body;

    public LambdaExpression(List<LambdaArgumentDeclaration> arguments, Expression body) {
        this(Optional.empty(), arguments, body);
    }

    public LambdaExpression(NodeLocation location, List<LambdaArgumentDeclaration> arguments, Expression body) {
        this(Optional.of(location), arguments, body);
    }

    public LambdaExpression(Optional<NodeLocation> location, List<LambdaArgumentDeclaration> arguments, Expression body) {
        super(location);
        this.arguments = Objects.requireNonNull(arguments, "arguments is null");
        this.body = Objects.requireNonNull(body, "body is null");
    }

    public List<LambdaArgumentDeclaration> getArguments() {
        return this.arguments;
    }

    public Expression getBody() {
        return this.body;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitLambdaExpression(this, context);
    }

    public List<Node> getChildren() {
        ImmutableList.Builder nodes = ImmutableList.builder();
        nodes.addAll(this.arguments);
        nodes.add((Object)this.body);
        return nodes.build();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LambdaExpression that = (LambdaExpression)obj;
        return Objects.equals(this.arguments, that.arguments) && Objects.equals(this.body, that.body);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.arguments, this.body);
    }
}

