/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class CreateType
extends Statement {
    private final QualifiedName typeName;
    private final Optional<String> distinctType;
    private final List<String> parameterNames;
    private final List<String> parameterTypes;

    public CreateType(QualifiedName typeName, String distinctType) {
        this(typeName, Optional.of(distinctType), (ImmutableList<String>)ImmutableList.of(), (ImmutableList<String>)ImmutableList.of());
    }

    public CreateType(QualifiedName typeName, ImmutableList<String> parameterNames, ImmutableList<String> parameterTypes) {
        this(typeName, Optional.empty(), parameterNames, parameterTypes);
    }

    private CreateType(QualifiedName typeName, Optional<String> distinctType, ImmutableList<String> parameterNames, ImmutableList<String> parameterTypes) {
        super(Optional.empty());
        Preconditions.checkArgument((parameterNames.size() == parameterTypes.size() ? 1 : 0) != 0, (Object)"Expected one type for each parameter name");
        Preconditions.checkArgument((distinctType.isPresent() || !parameterNames.isEmpty() ? 1 : 0) != 0, (Object)"Type can be either a distinct type or parameterized");
        this.typeName = typeName;
        this.distinctType = distinctType;
        this.parameterNames = parameterNames;
        this.parameterTypes = parameterTypes;
        HashSet parameterNamesSet = new HashSet();
        parameterNames.forEach(parameterName -> {
            Preconditions.checkArgument((!parameterNamesSet.contains(parameterName) ? 1 : 0) != 0, (Object)String.format("Duplicated member definition for %s in %s", parameterName, typeName));
            parameterNamesSet.add(parameterName);
        });
    }

    public QualifiedName getTypeName() {
        return this.typeName;
    }

    public Optional<String> getDistinctType() {
        return this.distinctType;
    }

    public List<String> getParameterNames() {
        return this.parameterNames;
    }

    public List<String> getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCreateType(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.typeName, this.distinctType, this.parameterNames, this.parameterTypes);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CreateType o = (CreateType)obj;
        return Objects.equals(this.typeName, o.typeName) && Objects.equals(this.distinctType, o.distinctType) && Objects.equals(this.parameterNames, o.parameterNames) && Objects.equals(this.parameterTypes, o.parameterTypes);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("typeName", (Object)this.typeName).add("distinctType", this.distinctType).add("parameterNames", this.parameterNames).add("parameterTypes", this.parameterTypes).toString();
    }
}

