/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.TableElement;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class ConstraintSpecification
extends TableElement {
    private final Optional<String> constraintName;
    private final List<String> columns;
    private final ConstraintType constraintType;
    private final boolean enabled;
    private final boolean rely;
    private final boolean enforced;

    public ConstraintSpecification(Optional<String> constraintName, List<String> columns, ConstraintType constraintType, boolean enabled, boolean rely, boolean enforced) {
        this(Optional.empty(), constraintName, columns, constraintType, enabled, rely, enforced);
    }

    public ConstraintSpecification(NodeLocation location, Optional<String> constraintName, List<String> columns, ConstraintType constraintType, boolean enabled, boolean rely, boolean enforced) {
        this(Optional.of(location), constraintName, columns, constraintType, enabled, rely, enforced);
    }

    private ConstraintSpecification(Optional<NodeLocation> location, Optional<String> constraintName, List<String> columns, ConstraintType constraintType, boolean enabled, boolean rely, boolean enforced) {
        super(location);
        this.constraintName = Objects.requireNonNull(constraintName, "constraint name is null");
        this.columns = Objects.requireNonNull(columns, "constraint columns is null");
        this.constraintType = constraintType;
        this.enabled = enabled;
        this.rely = rely;
        this.enforced = enforced;
    }

    public Optional<String> getConstraintName() {
        return this.constraintName;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public ConstraintType getConstraintType() {
        return this.constraintType;
    }

    public boolean isRely() {
        return this.rely;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isEnforced() {
        return this.enforced;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitConstraintSpecification(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ConstraintSpecification o = (ConstraintSpecification)obj;
        return Objects.equals(this.constraintName, o.constraintName) && Objects.equals(this.columns, o.columns) && Objects.equals((Object)this.constraintType, (Object)o.constraintType) && Objects.equals(this.rely, o.rely) && Objects.equals(this.enabled, o.enabled) && Objects.equals(this.enforced, o.enforced);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.constraintName, this.columns, this.constraintType, this.rely, this.enabled, this.enforced});
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("constraintName", this.constraintName).add("columns", this.columns).add("constraintType", (Object)this.constraintType).add("rely", this.rely).add("enabled", this.enabled).add("enforced", this.enforced).toString();
    }

    public static enum ConstraintType {
        UNIQUE,
        PRIMARY_KEY;

    }
}

