/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.parser;

import java.util.Objects;

public class ParsingWarning {
    private final int lineNumber;
    private final int columnNumber;
    private final String warning;

    public ParsingWarning(String warning, int line, int columnNumber) {
        this.warning = Objects.requireNonNull(warning, "warning is null");
        this.lineNumber = line;
        this.columnNumber = columnNumber;
    }

    public ParsingWarning(String message) {
        this(message, 1, 1);
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public String getWarning() {
        return this.warning;
    }

    public String getMessage() {
        return String.format("lineNumber %s:%s: %s", this.lineNumber, this.columnNumber, this.getWarning());
    }
}

