/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.ColumnDefinition;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class AddColumn
extends Statement {
    private final QualifiedName name;
    private final ColumnDefinition column;
    private final boolean tableExists;
    private final boolean columnNotExists;

    public AddColumn(QualifiedName name, ColumnDefinition column, boolean tableExists, boolean columnNotExists) {
        this(Optional.empty(), name, column, tableExists, columnNotExists);
    }

    public AddColumn(NodeLocation location, QualifiedName name, ColumnDefinition column, boolean tableExists, boolean columnNotExists) {
        this(Optional.of(location), name, column, tableExists, columnNotExists);
    }

    private AddColumn(Optional<NodeLocation> location, QualifiedName name, ColumnDefinition column, boolean tableExists, boolean columnNotExists) {
        super(location);
        this.name = Objects.requireNonNull(name, "table is null");
        this.column = Objects.requireNonNull(column, "column is null");
        this.tableExists = tableExists;
        this.columnNotExists = columnNotExists;
    }

    public QualifiedName getName() {
        return this.name;
    }

    public ColumnDefinition getColumn() {
        return this.column;
    }

    public boolean isTableExists() {
        return this.tableExists;
    }

    public boolean isColumnNotExists() {
        return this.columnNotExists;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitAddColumn(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of((Object)this.column);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.column, this.tableExists, this.columnNotExists);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AddColumn o = (AddColumn)obj;
        return Objects.equals(this.name, o.name) && Objects.equals(this.column, o.column) && Objects.equals(this.tableExists, o.tableExists) && Objects.equals(this.columnNotExists, o.columnNotExists);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("column", (Object)this.column).add("tableExists", this.tableExists).add("columnNotExists", this.columnNotExists).toString();
    }
}

