/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ShowRoles
extends Statement {
    private final Optional<Identifier> catalog;
    private final boolean current;

    public ShowRoles(Optional<Identifier> catalog, boolean current) {
        this(Optional.empty(), catalog, current);
    }

    public ShowRoles(NodeLocation location, Optional<Identifier> catalog, boolean current) {
        this(Optional.of(location), catalog, current);
    }

    public ShowRoles(Optional<NodeLocation> location, Optional<Identifier> catalog, boolean current) {
        super(location);
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        this.current = current;
    }

    public Optional<Identifier> getCatalog() {
        return this.catalog;
    }

    public boolean isCurrent() {
        return this.current;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitShowRoles(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.catalog, this.current);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ShowRoles o = (ShowRoles)obj;
        return Objects.equals(this.catalog, o.catalog) && this.current == o.current;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("catalog", this.catalog).add("current", this.current).toString();
    }
}

