/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.GrantorSpecification;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class CreateRole
extends Statement {
    private final Identifier name;
    private final Optional<GrantorSpecification> grantor;

    public CreateRole(Identifier name, Optional<GrantorSpecification> grantor) {
        this(Optional.empty(), name, grantor);
    }

    public CreateRole(NodeLocation location, Identifier name, Optional<GrantorSpecification> grantor) {
        this(Optional.of(location), name, grantor);
    }

    private CreateRole(Optional<NodeLocation> location, Identifier name, Optional<GrantorSpecification> grantor) {
        super(location);
        this.name = Objects.requireNonNull(name, "name is null");
        this.grantor = Objects.requireNonNull(grantor, "grantor is null");
    }

    public Identifier getName() {
        return this.name;
    }

    public Optional<GrantorSpecification> getGrantor() {
        return this.grantor;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateRole that = (CreateRole)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.grantor, that.grantor);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.grantor);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("grantor", this.grantor).toString();
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCreateRole(this, context);
    }
}

