/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.Property;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class CreateMaterializedView
extends Statement {
    private final QualifiedName name;
    private final Query query;
    private final boolean notExists;
    private final List<Property> properties;
    private final Optional<String> comment;

    public CreateMaterializedView(QualifiedName name, Query query, boolean notExists, List<Property> properties, Optional<String> comment) {
        this(Optional.empty(), name, query, notExists, properties, comment);
    }

    public CreateMaterializedView(Optional<NodeLocation> location, QualifiedName name, Query query, boolean notExists, List<Property> properties, Optional<String> comment) {
        super(location);
        this.name = Objects.requireNonNull(name, "name is null");
        this.query = Objects.requireNonNull(query, "query is null");
        this.notExists = notExists;
        this.properties = ImmutableList.copyOf((Collection)Objects.requireNonNull(properties, "properties is null"));
        this.comment = Objects.requireNonNull(comment, "comment is null");
    }

    public QualifiedName getName() {
        return this.name;
    }

    public Query getQuery() {
        return this.query;
    }

    public boolean isNotExists() {
        return this.notExists;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public Optional<String> getComment() {
        return this.comment;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCreateMaterializedView(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.builder().add((Object)this.query).addAll(this.properties).build();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.query, this.notExists, this.properties, this.comment);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CreateMaterializedView o = (CreateMaterializedView)obj;
        return Objects.equals(this.name, o.name) && Objects.equals(this.query, o.query) && Objects.equals(this.notExists, o.notExists) && Objects.equals(this.properties, o.properties) && Objects.equals(this.comment, o.comment);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("query", (Object)this.query).add("notExists", this.notExists).add("properties", this.properties).add("comment", this.comment).toString();
    }
}

