/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql;

import com.facebook.presto.sql.ExpressionFormatter;
import com.facebook.presto.sql.tree.AddColumn;
import com.facebook.presto.sql.tree.AliasedRelation;
import com.facebook.presto.sql.tree.AllColumns;
import com.facebook.presto.sql.tree.AlterFunction;
import com.facebook.presto.sql.tree.AlterRoutineCharacteristics;
import com.facebook.presto.sql.tree.Analyze;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Call;
import com.facebook.presto.sql.tree.CallArgument;
import com.facebook.presto.sql.tree.ColumnDefinition;
import com.facebook.presto.sql.tree.Commit;
import com.facebook.presto.sql.tree.CreateFunction;
import com.facebook.presto.sql.tree.CreateMaterializedView;
import com.facebook.presto.sql.tree.CreateRole;
import com.facebook.presto.sql.tree.CreateSchema;
import com.facebook.presto.sql.tree.CreateTable;
import com.facebook.presto.sql.tree.CreateTableAsSelect;
import com.facebook.presto.sql.tree.CreateView;
import com.facebook.presto.sql.tree.Deallocate;
import com.facebook.presto.sql.tree.Delete;
import com.facebook.presto.sql.tree.DescribeInput;
import com.facebook.presto.sql.tree.DescribeOutput;
import com.facebook.presto.sql.tree.DropColumn;
import com.facebook.presto.sql.tree.DropFunction;
import com.facebook.presto.sql.tree.DropRole;
import com.facebook.presto.sql.tree.DropSchema;
import com.facebook.presto.sql.tree.DropTable;
import com.facebook.presto.sql.tree.DropView;
import com.facebook.presto.sql.tree.Except;
import com.facebook.presto.sql.tree.Execute;
import com.facebook.presto.sql.tree.Explain;
import com.facebook.presto.sql.tree.ExplainFormat;
import com.facebook.presto.sql.tree.ExplainOption;
import com.facebook.presto.sql.tree.ExplainType;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExternalBodyReference;
import com.facebook.presto.sql.tree.Grant;
import com.facebook.presto.sql.tree.GrantRoles;
import com.facebook.presto.sql.tree.GrantorSpecification;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.Insert;
import com.facebook.presto.sql.tree.Intersect;
import com.facebook.presto.sql.tree.Isolation;
import com.facebook.presto.sql.tree.Join;
import com.facebook.presto.sql.tree.JoinCriteria;
import com.facebook.presto.sql.tree.JoinOn;
import com.facebook.presto.sql.tree.JoinUsing;
import com.facebook.presto.sql.tree.Lateral;
import com.facebook.presto.sql.tree.LikeClause;
import com.facebook.presto.sql.tree.NaturalJoin;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.OrderBy;
import com.facebook.presto.sql.tree.Prepare;
import com.facebook.presto.sql.tree.PrincipalSpecification;
import com.facebook.presto.sql.tree.Property;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.RenameColumn;
import com.facebook.presto.sql.tree.RenameSchema;
import com.facebook.presto.sql.tree.RenameTable;
import com.facebook.presto.sql.tree.ResetSession;
import com.facebook.presto.sql.tree.Return;
import com.facebook.presto.sql.tree.Revoke;
import com.facebook.presto.sql.tree.RevokeRoles;
import com.facebook.presto.sql.tree.Rollback;
import com.facebook.presto.sql.tree.RoutineCharacteristics;
import com.facebook.presto.sql.tree.Row;
import com.facebook.presto.sql.tree.SampledRelation;
import com.facebook.presto.sql.tree.Select;
import com.facebook.presto.sql.tree.SelectItem;
import com.facebook.presto.sql.tree.SetRole;
import com.facebook.presto.sql.tree.SetSession;
import com.facebook.presto.sql.tree.ShowCatalogs;
import com.facebook.presto.sql.tree.ShowColumns;
import com.facebook.presto.sql.tree.ShowCreate;
import com.facebook.presto.sql.tree.ShowCreateFunction;
import com.facebook.presto.sql.tree.ShowFunctions;
import com.facebook.presto.sql.tree.ShowGrants;
import com.facebook.presto.sql.tree.ShowRoleGrants;
import com.facebook.presto.sql.tree.ShowRoles;
import com.facebook.presto.sql.tree.ShowSchemas;
import com.facebook.presto.sql.tree.ShowSession;
import com.facebook.presto.sql.tree.ShowStats;
import com.facebook.presto.sql.tree.ShowTables;
import com.facebook.presto.sql.tree.SingleColumn;
import com.facebook.presto.sql.tree.SqlParameterDeclaration;
import com.facebook.presto.sql.tree.StartTransaction;
import com.facebook.presto.sql.tree.Table;
import com.facebook.presto.sql.tree.TableSubquery;
import com.facebook.presto.sql.tree.TransactionAccessMode;
import com.facebook.presto.sql.tree.TransactionMode;
import com.facebook.presto.sql.tree.Union;
import com.facebook.presto.sql.tree.Unnest;
import com.facebook.presto.sql.tree.Use;
import com.facebook.presto.sql.tree.Values;
import com.facebook.presto.sql.tree.With;
import com.facebook.presto.sql.tree.WithQuery;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class SqlFormatter {
    private static final String INDENT = "   ";
    private static final Pattern NAME_PATTERN = Pattern.compile("[a-z_][a-z0-9_]*");

    private SqlFormatter() {
    }

    public static String formatSql(Node root, Optional<List<Expression>> parameters) {
        StringBuilder builder = new StringBuilder();
        new Formatter(builder, parameters).process(root, 0);
        return builder.toString();
    }

    private static void appendAliasColumns(StringBuilder builder, List<Identifier> columns) {
        if (columns != null && !columns.isEmpty()) {
            String formattedColumns = columns.stream().map(name -> ExpressionFormatter.formatExpression(name, Optional.empty())).collect(Collectors.joining(", "));
            builder.append(" (").append(formattedColumns).append(')');
        }
    }

    private static class Formatter
    extends AstVisitor<Void, Integer> {
        private final StringBuilder builder;
        private final Optional<List<Expression>> parameters;

        public Formatter(StringBuilder builder, Optional<List<Expression>> parameters) {
            this.builder = builder;
            this.parameters = parameters;
        }

        @Override
        protected Void visitNode(Node node, Integer indent) {
            throw new UnsupportedOperationException("not yet implemented: " + node);
        }

        @Override
        protected Void visitExpression(Expression node, Integer indent) {
            Preconditions.checkArgument((indent == 0 ? 1 : 0) != 0, (Object)"visitExpression should only be called at root");
            this.builder.append(ExpressionFormatter.formatExpression(node, this.parameters));
            return null;
        }

        @Override
        protected Void visitUnnest(Unnest node, Integer indent) {
            this.builder.append("UNNEST(").append(node.getExpressions().stream().map(expression -> ExpressionFormatter.formatExpression(expression, this.parameters)).collect(Collectors.joining(", "))).append(")");
            if (node.isWithOrdinality()) {
                this.builder.append(" WITH ORDINALITY");
            }
            return null;
        }

        @Override
        protected Void visitLateral(Lateral node, Integer indent) {
            this.append(indent, "LATERAL (");
            this.process(node.getQuery(), indent + 1);
            this.append(indent, ")");
            return null;
        }

        @Override
        protected Void visitPrepare(Prepare node, Integer indent) {
            this.append(indent, "PREPARE ");
            this.builder.append(node.getName());
            this.builder.append(" FROM");
            this.builder.append("\n");
            this.process(node.getStatement(), indent + 1);
            return null;
        }

        @Override
        protected Void visitDeallocate(Deallocate node, Integer indent) {
            this.append(indent, "DEALLOCATE PREPARE ");
            this.builder.append(node.getName());
            return null;
        }

        @Override
        protected Void visitExecute(Execute node, Integer indent) {
            this.append(indent, "EXECUTE ");
            this.builder.append(node.getName());
            List<Expression> parameters = node.getParameters();
            if (!parameters.isEmpty()) {
                this.builder.append(" USING ");
                Joiner.on((String)", ").appendTo(this.builder, parameters);
            }
            return null;
        }

        @Override
        protected Void visitDescribeOutput(DescribeOutput node, Integer indent) {
            this.append(indent, "DESCRIBE OUTPUT ");
            this.builder.append(node.getName());
            return null;
        }

        @Override
        protected Void visitDescribeInput(DescribeInput node, Integer indent) {
            this.append(indent, "DESCRIBE INPUT ");
            this.builder.append(node.getName());
            return null;
        }

        @Override
        protected Void visitQuery(Query node, Integer indent) {
            if (node.getWith().isPresent()) {
                With with = node.getWith().get();
                this.append(indent, "WITH");
                if (with.isRecursive()) {
                    this.builder.append(" RECURSIVE");
                }
                this.builder.append("\n  ");
                Iterator<WithQuery> queries = with.getQueries().iterator();
                while (queries.hasNext()) {
                    WithQuery query = queries.next();
                    this.append(indent, ExpressionFormatter.formatExpression(query.getName(), this.parameters));
                    query.getColumnNames().ifPresent(columnNames -> SqlFormatter.appendAliasColumns(this.builder, columnNames));
                    this.builder.append(" AS ");
                    this.process(new TableSubquery(query.getQuery()), indent);
                    this.builder.append('\n');
                    if (!queries.hasNext()) continue;
                    this.builder.append(", ");
                }
            }
            this.processRelation(node.getQueryBody(), indent);
            if (node.getOrderBy().isPresent()) {
                this.process(node.getOrderBy().get(), indent);
            }
            if (node.getLimit().isPresent()) {
                this.append(indent, "LIMIT " + node.getLimit().get()).append('\n');
            }
            return null;
        }

        @Override
        protected Void visitQuerySpecification(QuerySpecification node, Integer indent) {
            this.process(node.getSelect(), indent);
            if (node.getFrom().isPresent()) {
                this.append(indent, "FROM");
                this.builder.append('\n');
                this.append(indent, "  ");
                this.process(node.getFrom().get(), indent);
            }
            this.builder.append('\n');
            if (node.getWhere().isPresent()) {
                this.append(indent, "WHERE " + ExpressionFormatter.formatExpression(node.getWhere().get(), this.parameters)).append('\n');
            }
            if (node.getGroupBy().isPresent()) {
                this.append(indent, "GROUP BY " + (node.getGroupBy().get().isDistinct() ? " DISTINCT " : "") + ExpressionFormatter.formatGroupBy(node.getGroupBy().get().getGroupingElements())).append('\n');
            }
            if (node.getHaving().isPresent()) {
                this.append(indent, "HAVING " + ExpressionFormatter.formatExpression(node.getHaving().get(), this.parameters)).append('\n');
            }
            if (node.getOrderBy().isPresent()) {
                this.process(node.getOrderBy().get(), indent);
            }
            if (node.getLimit().isPresent()) {
                this.append(indent, "LIMIT " + node.getLimit().get()).append('\n');
            }
            return null;
        }

        @Override
        protected Void visitOrderBy(OrderBy node, Integer indent) {
            this.append(indent, ExpressionFormatter.formatOrderBy(node, this.parameters)).append('\n');
            return null;
        }

        @Override
        protected Void visitSelect(Select node, Integer indent) {
            this.append(indent, "SELECT");
            if (node.isDistinct()) {
                this.builder.append(" DISTINCT");
            }
            if (node.getSelectItems().size() > 1) {
                boolean first = true;
                for (SelectItem item : node.getSelectItems()) {
                    this.builder.append("\n").append(Formatter.indentString(indent)).append(first ? "  " : ", ");
                    this.process(item, indent);
                    first = false;
                }
            } else {
                this.builder.append(' ');
                this.process((Node)Iterables.getOnlyElement(node.getSelectItems()), indent);
            }
            this.builder.append('\n');
            return null;
        }

        @Override
        protected Void visitSingleColumn(SingleColumn node, Integer indent) {
            this.builder.append(ExpressionFormatter.formatExpression(node.getExpression(), this.parameters));
            if (node.getAlias().isPresent()) {
                this.builder.append(' ').append(ExpressionFormatter.formatExpression(node.getAlias().get(), this.parameters));
            }
            return null;
        }

        @Override
        protected Void visitAllColumns(AllColumns node, Integer context) {
            this.builder.append(node.toString());
            return null;
        }

        @Override
        protected Void visitTable(Table node, Integer indent) {
            this.builder.append(Formatter.formatName(node.getName()));
            return null;
        }

        @Override
        protected Void visitJoin(Join node, Integer indent) {
            JoinCriteria criteria = node.getCriteria().orElse(null);
            String type = node.getType().toString();
            if (criteria instanceof NaturalJoin) {
                type = "NATURAL " + type;
            }
            if (node.getType() != Join.Type.IMPLICIT) {
                this.builder.append('(');
            }
            this.process(node.getLeft(), indent);
            this.builder.append('\n');
            if (node.getType() == Join.Type.IMPLICIT) {
                this.append(indent, ", ");
            } else {
                this.append(indent, type).append(" JOIN ");
            }
            this.process(node.getRight(), indent);
            if (node.getType() != Join.Type.CROSS && node.getType() != Join.Type.IMPLICIT) {
                if (criteria instanceof JoinUsing) {
                    JoinUsing using = (JoinUsing)criteria;
                    this.builder.append(" USING (").append(Joiner.on((String)", ").join(using.getColumns())).append(")");
                } else if (criteria instanceof JoinOn) {
                    JoinOn on = (JoinOn)criteria;
                    this.builder.append(" ON ").append(ExpressionFormatter.formatExpression(on.getExpression(), this.parameters));
                } else if (!(criteria instanceof NaturalJoin)) {
                    throw new UnsupportedOperationException("unknown join criteria: " + criteria);
                }
            }
            if (node.getType() != Join.Type.IMPLICIT) {
                this.builder.append(")");
            }
            return null;
        }

        @Override
        protected Void visitAliasedRelation(AliasedRelation node, Integer indent) {
            this.process(node.getRelation(), indent);
            this.builder.append(' ').append(ExpressionFormatter.formatExpression(node.getAlias(), this.parameters));
            SqlFormatter.appendAliasColumns(this.builder, node.getColumnNames());
            return null;
        }

        @Override
        protected Void visitSampledRelation(SampledRelation node, Integer indent) {
            this.process(node.getRelation(), indent);
            this.builder.append(" TABLESAMPLE ").append((Object)node.getType()).append(" (").append(node.getSamplePercentage()).append(')');
            return null;
        }

        @Override
        protected Void visitValues(Values node, Integer indent) {
            this.builder.append(" VALUES ");
            boolean first = true;
            for (Expression row : node.getRows()) {
                this.builder.append("\n").append(Formatter.indentString(indent)).append(first ? "  " : ", ");
                this.builder.append(ExpressionFormatter.formatExpression(row, this.parameters));
                first = false;
            }
            this.builder.append('\n');
            return null;
        }

        @Override
        protected Void visitTableSubquery(TableSubquery node, Integer indent) {
            this.builder.append('(').append('\n');
            this.process(node.getQuery(), indent + 1);
            this.append(indent, ") ");
            return null;
        }

        @Override
        protected Void visitUnion(Union node, Integer indent) {
            Iterator<Relation> relations = node.getRelations().iterator();
            while (relations.hasNext()) {
                this.processRelation(relations.next(), indent);
                if (!relations.hasNext()) continue;
                this.builder.append("UNION ");
                node.isDistinct().map(distinct -> distinct != false ? this.builder.append("DISTINCT ") : this.builder.append("ALL "));
            }
            return null;
        }

        @Override
        protected Void visitExcept(Except node, Integer indent) {
            this.processRelation(node.getLeft(), indent);
            this.builder.append("EXCEPT ");
            node.isDistinct().map(distinct -> distinct != false ? this.builder.append("DISTINCT ") : this.builder.append("ALL "));
            this.processRelation(node.getRight(), indent);
            return null;
        }

        @Override
        protected Void visitIntersect(Intersect node, Integer indent) {
            Iterator<Relation> relations = node.getRelations().iterator();
            while (relations.hasNext()) {
                this.processRelation(relations.next(), indent);
                if (!relations.hasNext()) continue;
                this.builder.append("INTERSECT ");
                node.isDistinct().map(distinct -> distinct != false ? this.builder.append("DISTINCT ") : this.builder.append("ALL "));
            }
            return null;
        }

        @Override
        protected Void visitCreateView(CreateView node, Integer indent) {
            this.builder.append("CREATE ");
            if (node.isReplace()) {
                this.builder.append("OR REPLACE ");
            }
            this.builder.append("VIEW ").append(Formatter.formatName(node.getName()));
            node.getSecurity().ifPresent(security -> this.builder.append(" SECURITY ").append(security.toString()).append(" "));
            this.builder.append(" AS\n");
            this.process(node.getQuery(), indent);
            return null;
        }

        @Override
        protected Void visitCreateMaterializedView(CreateMaterializedView node, Integer indent) {
            this.builder.append("CREATE MATERIALIZED VIEW ");
            if (node.isNotExists()) {
                this.builder.append("IF NOT EXISTS ");
            }
            this.builder.append(Formatter.formatName(node.getName()));
            if (node.getComment().isPresent()) {
                this.builder.append("\nCOMMENT " + ExpressionFormatter.formatStringLiteral(node.getComment().get()));
            }
            this.builder.append(this.formatPropertiesMultiLine(node.getProperties()));
            this.builder.append(" AS ");
            this.process(node.getQuery(), indent);
            return null;
        }

        @Override
        protected Void visitCreateFunction(CreateFunction node, Integer indent) {
            this.builder.append("CREATE ");
            if (node.isTemporary()) {
                this.builder.append("TEMPORARY ");
            }
            this.builder.append("FUNCTION ").append(Formatter.formatName(node.getFunctionName())).append(" ").append(this.formatSqlParameterDeclarations(node.getParameters())).append("\nRETURNS ").append(node.getReturnType());
            if (node.getComment().isPresent()) {
                this.builder.append("\nCOMMENT ").append(ExpressionFormatter.formatStringLiteral(node.getComment().get()));
            }
            this.builder.append("\n").append(this.formatRoutineCharacteristics(node.getCharacteristics())).append("\n");
            this.process(node.getBody(), 0);
            return null;
        }

        @Override
        protected Void visitAlterFunction(AlterFunction node, Integer indent) {
            this.builder.append("ALTER FUNCTION ").append(Formatter.formatName(node.getFunctionName()));
            node.getParameterTypes().map(Formatter::formatTypeList).ifPresent(this.builder::append);
            this.builder.append("\n").append(this.formatAlterRoutineCharacteristics(node.getCharacteristics()));
            return null;
        }

        @Override
        protected Void visitDropFunction(DropFunction node, Integer indent) {
            this.builder.append("DROP ");
            if (node.isTemporary()) {
                this.builder.append("TEMPORARY ");
            }
            this.builder.append("FUNCTION ");
            if (node.isExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(Formatter.formatName(node.getFunctionName()));
            node.getParameterTypes().map(Formatter::formatTypeList).ifPresent(this.builder::append);
            return null;
        }

        @Override
        protected Void visitReturn(Return node, Integer indent) {
            this.append(indent, "RETURN ");
            this.builder.append(ExpressionFormatter.formatExpression(node.getExpression(), this.parameters));
            return null;
        }

        @Override
        protected Void visitExternalBodyReference(ExternalBodyReference node, Integer indent) {
            this.append(indent, "EXTERNAL");
            if (node.getIdentifier().isPresent()) {
                this.builder.append(" NAME ");
                this.builder.append(node.getIdentifier().get().toString());
            }
            return null;
        }

        @Override
        protected Void visitDropView(DropView node, Integer context) {
            this.builder.append("DROP VIEW ");
            if (node.isExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(node.getName());
            return null;
        }

        @Override
        protected Void visitExplain(Explain node, Integer indent) {
            this.builder.append("EXPLAIN ");
            if (node.isAnalyze()) {
                this.builder.append("ANALYZE ");
            }
            ArrayList<String> options = new ArrayList<String>();
            for (ExplainOption option : node.getOptions()) {
                if (option instanceof ExplainType) {
                    options.add("TYPE " + (Object)((Object)((ExplainType)option).getType()));
                    continue;
                }
                if (option instanceof ExplainFormat) {
                    options.add("FORMAT " + (Object)((Object)((ExplainFormat)option).getType()));
                    continue;
                }
                throw new UnsupportedOperationException("unhandled explain option: " + option);
            }
            if (!options.isEmpty()) {
                this.builder.append("(");
                Joiner.on((String)", ").appendTo(this.builder, options);
                this.builder.append(")");
            }
            this.builder.append("\n");
            this.process(node.getStatement(), indent);
            return null;
        }

        @Override
        protected Void visitShowCatalogs(ShowCatalogs node, Integer context) {
            this.builder.append("SHOW CATALOGS");
            node.getLikePattern().ifPresent(value -> this.builder.append(" LIKE ").append(ExpressionFormatter.formatStringLiteral(value)));
            return null;
        }

        @Override
        protected Void visitShowSchemas(ShowSchemas node, Integer context) {
            this.builder.append("SHOW SCHEMAS");
            if (node.getCatalog().isPresent()) {
                this.builder.append(" FROM ").append(node.getCatalog().get());
            }
            node.getLikePattern().ifPresent(value -> this.builder.append(" LIKE ").append(ExpressionFormatter.formatStringLiteral(value)));
            node.getEscape().ifPresent(value -> this.builder.append(" ESCAPE ").append(ExpressionFormatter.formatStringLiteral(value)));
            return null;
        }

        @Override
        protected Void visitShowTables(ShowTables node, Integer context) {
            this.builder.append("SHOW TABLES");
            node.getSchema().ifPresent(value -> this.builder.append(" FROM ").append(Formatter.formatName(value)));
            node.getLikePattern().ifPresent(value -> this.builder.append(" LIKE ").append(ExpressionFormatter.formatStringLiteral(value)));
            node.getEscape().ifPresent(value -> this.builder.append(" ESCAPE ").append(ExpressionFormatter.formatStringLiteral(value)));
            return null;
        }

        @Override
        protected Void visitShowCreate(ShowCreate node, Integer context) {
            if (node.getType() == ShowCreate.Type.TABLE) {
                this.builder.append("SHOW CREATE TABLE ").append(Formatter.formatName(node.getName()));
            } else if (node.getType() == ShowCreate.Type.VIEW) {
                this.builder.append("SHOW CREATE VIEW ").append(Formatter.formatName(node.getName()));
            }
            return null;
        }

        @Override
        protected Void visitShowCreateFunction(ShowCreateFunction node, Integer context) {
            this.builder.append("SHOW CREATE FUNCTION ").append(Formatter.formatName(node.getName()));
            node.getParameterTypes().map(Formatter::formatTypeList).ifPresent(this.builder::append);
            return null;
        }

        @Override
        protected Void visitShowColumns(ShowColumns node, Integer context) {
            this.builder.append("SHOW COLUMNS FROM ").append(Formatter.formatName(node.getTable()));
            return null;
        }

        @Override
        protected Void visitShowStats(ShowStats node, Integer context) {
            this.builder.append("SHOW STATS FOR ");
            this.process(node.getRelation(), 0);
            this.builder.append("");
            return null;
        }

        @Override
        protected Void visitShowFunctions(ShowFunctions node, Integer context) {
            this.builder.append("SHOW FUNCTIONS");
            node.getLikePattern().ifPresent(value -> this.builder.append(" LIKE ").append(ExpressionFormatter.formatStringLiteral(value)));
            node.getEscape().ifPresent(value -> this.builder.append(" ESCAPE ").append(ExpressionFormatter.formatStringLiteral(value)));
            return null;
        }

        @Override
        protected Void visitUse(Use node, Integer context) {
            this.builder.append("USE ");
            if (node.getCatalog().isPresent()) {
                this.builder.append(ExpressionFormatter.formatExpression(node.getCatalog().get(), Optional.empty())).append(".");
            }
            this.builder.append(ExpressionFormatter.formatExpression(node.getSchema(), Optional.empty()));
            return null;
        }

        @Override
        protected Void visitShowSession(ShowSession node, Integer context) {
            this.builder.append("SHOW SESSION");
            return null;
        }

        @Override
        protected Void visitDelete(Delete node, Integer context) {
            this.builder.append("DELETE FROM ").append(Formatter.formatName(node.getTable().getName()));
            if (node.getWhere().isPresent()) {
                this.builder.append(" WHERE ").append(ExpressionFormatter.formatExpression(node.getWhere().get(), this.parameters));
            }
            return null;
        }

        @Override
        protected Void visitCreateSchema(CreateSchema node, Integer context) {
            this.builder.append("CREATE SCHEMA ");
            if (node.isNotExists()) {
                this.builder.append("IF NOT EXISTS ");
            }
            this.builder.append(Formatter.formatName(node.getSchemaName()));
            this.builder.append(this.formatPropertiesMultiLine(node.getProperties()));
            return null;
        }

        @Override
        protected Void visitDropSchema(DropSchema node, Integer context) {
            this.builder.append("DROP SCHEMA ");
            if (node.isExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(Formatter.formatName(node.getSchemaName())).append(" ").append(node.isCascade() ? "CASCADE" : "RESTRICT");
            return null;
        }

        @Override
        protected Void visitRenameSchema(RenameSchema node, Integer context) {
            this.builder.append("ALTER SCHEMA ").append(Formatter.formatName(node.getSource())).append(" RENAME TO ").append(ExpressionFormatter.formatExpression(node.getTarget(), this.parameters));
            return null;
        }

        @Override
        protected Void visitCreateTableAsSelect(CreateTableAsSelect node, Integer indent) {
            this.builder.append("CREATE TABLE ");
            if (node.isNotExists()) {
                this.builder.append("IF NOT EXISTS ");
            }
            this.builder.append(Formatter.formatName(node.getName()));
            if (node.getColumnAliases().isPresent()) {
                String columnList = node.getColumnAliases().get().stream().map(element -> ExpressionFormatter.formatExpression(element, this.parameters)).collect(Collectors.joining(", "));
                this.builder.append(String.format("( %s )", columnList));
            }
            if (node.getComment().isPresent()) {
                this.builder.append("\nCOMMENT " + ExpressionFormatter.formatStringLiteral(node.getComment().get()));
            }
            this.builder.append(this.formatPropertiesMultiLine(node.getProperties()));
            this.builder.append(" AS ");
            this.process(node.getQuery(), indent);
            if (!node.isWithData()) {
                this.builder.append(" WITH NO DATA");
            }
            return null;
        }

        @Override
        protected Void visitCreateTable(CreateTable node, Integer indent) {
            this.builder.append("CREATE TABLE ");
            if (node.isNotExists()) {
                this.builder.append("IF NOT EXISTS ");
            }
            String tableName = Formatter.formatName(node.getName());
            this.builder.append(tableName).append(" (\n");
            String elementIndent = Formatter.indentString(indent + 1);
            String columnList = node.getElements().stream().map(element -> {
                if (element instanceof ColumnDefinition) {
                    ColumnDefinition column = (ColumnDefinition)element;
                    return elementIndent + this.formatColumnDefinition(column);
                }
                if (element instanceof LikeClause) {
                    LikeClause likeClause = (LikeClause)element;
                    StringBuilder builder = new StringBuilder(elementIndent);
                    builder.append("LIKE ").append(Formatter.formatName(likeClause.getTableName()));
                    if (likeClause.getPropertiesOption().isPresent()) {
                        builder.append(" ").append(likeClause.getPropertiesOption().get().name()).append(" PROPERTIES");
                    }
                    return builder.toString();
                }
                throw new UnsupportedOperationException("unknown table element: " + element);
            }).collect(Collectors.joining(",\n"));
            this.builder.append(columnList);
            this.builder.append("\n").append(")");
            if (node.getComment().isPresent()) {
                this.builder.append("\nCOMMENT " + ExpressionFormatter.formatStringLiteral(node.getComment().get()));
            }
            this.builder.append(this.formatPropertiesMultiLine(node.getProperties()));
            return null;
        }

        private String formatPropertiesMultiLine(List<Property> properties) {
            if (properties.isEmpty()) {
                return "";
            }
            String propertyList = properties.stream().map(element -> SqlFormatter.INDENT + ExpressionFormatter.formatExpression(element.getName(), this.parameters) + " = " + ExpressionFormatter.formatExpression(element.getValue(), this.parameters)).collect(Collectors.joining(",\n"));
            return "\nWITH (\n" + propertyList + "\n)";
        }

        private String formatPropertiesSingleLine(List<Property> properties) {
            if (properties.isEmpty()) {
                return "";
            }
            String propertyList = properties.stream().map(element -> ExpressionFormatter.formatExpression(element.getName(), this.parameters) + " = " + ExpressionFormatter.formatExpression(element.getValue(), this.parameters)).collect(Collectors.joining(", "));
            return " WITH ( " + propertyList + " )";
        }

        private String formatSqlParameterDeclarations(List<SqlParameterDeclaration> parameters) {
            if (parameters.isEmpty()) {
                return "()";
            }
            return parameters.stream().map(parameter -> String.format("%s%s %s", SqlFormatter.INDENT, ExpressionFormatter.formatExpression(parameter.getName(), this.parameters), parameter.getType())).collect(Collectors.joining(",\n", "(\n", "\n)"));
        }

        private static String formatTypeList(List<String> types) {
            return String.format("(%s)", Joiner.on((String)", ").join(types));
        }

        private String formatRoutineCharacteristics(RoutineCharacteristics characteristics) {
            return Joiner.on((String)"\n").join((Iterable)ImmutableList.of((Object)("LANGUAGE " + characteristics.getLanguage()), (Object)this.formatRoutineCharacteristicName(characteristics.getDeterminism()), (Object)this.formatRoutineCharacteristicName(characteristics.getNullCallClause())));
        }

        private String formatAlterRoutineCharacteristics(AlterRoutineCharacteristics characteristics) {
            StringBuilder formatted = new StringBuilder();
            if (characteristics.getNullCallClause().isPresent()) {
                formatted.append(this.formatRoutineCharacteristicName(characteristics.getNullCallClause().get()));
            }
            return formatted.toString();
        }

        private String formatRoutineCharacteristicName(Enum characteristic) {
            return characteristic.name().replace("_", " ");
        }

        private static String formatName(String name) {
            if (NAME_PATTERN.matcher(name).matches()) {
                return name;
            }
            return "\"" + name.replace("\"", "\"\"") + "\"";
        }

        private static String formatName(QualifiedName name) {
            return name.getOriginalParts().stream().map(Formatter::formatName).collect(Collectors.joining("."));
        }

        private String formatColumnDefinition(ColumnDefinition column) {
            StringBuilder sb = new StringBuilder().append(ExpressionFormatter.formatExpression(column.getName(), this.parameters)).append(" ").append(column.getType());
            if (!column.isNullable()) {
                sb.append(" NOT NULL");
            }
            column.getComment().ifPresent(comment -> sb.append(" COMMENT ").append(ExpressionFormatter.formatStringLiteral(comment)));
            sb.append(this.formatPropertiesSingleLine(column.getProperties()));
            return sb.toString();
        }

        private static String formatGrantor(GrantorSpecification grantor) {
            GrantorSpecification.Type type = grantor.getType();
            switch (type) {
                case CURRENT_ROLE: 
                case CURRENT_USER: {
                    return type.name();
                }
                case PRINCIPAL: {
                    return Formatter.formatPrincipal(grantor.getPrincipal().get());
                }
            }
            throw new IllegalArgumentException("Unsupported principal type: " + (Object)((Object)type));
        }

        private static String formatPrincipal(PrincipalSpecification principal) {
            PrincipalSpecification.Type type = principal.getType();
            switch (type) {
                case UNSPECIFIED: {
                    return principal.getName().toString();
                }
                case USER: 
                case ROLE: {
                    return String.format("%s %s", type.name(), principal.getName().toString());
                }
            }
            throw new IllegalArgumentException("Unsupported principal type: " + (Object)((Object)type));
        }

        @Override
        protected Void visitDropTable(DropTable node, Integer context) {
            this.builder.append("DROP TABLE ");
            if (node.isExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(node.getTableName());
            return null;
        }

        @Override
        protected Void visitRenameTable(RenameTable node, Integer context) {
            this.builder.append("ALTER TABLE ");
            if (node.isExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(node.getSource()).append(" RENAME TO ").append(node.getTarget());
            return null;
        }

        @Override
        protected Void visitRenameColumn(RenameColumn node, Integer context) {
            this.builder.append("ALTER TABLE ");
            if (node.isTableExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(node.getTable()).append(" RENAME COLUMN ");
            if (node.isColumnExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(node.getSource()).append(" TO ").append(node.getTarget());
            return null;
        }

        @Override
        protected Void visitDropColumn(DropColumn node, Integer context) {
            this.builder.append("ALTER TABLE ");
            if (node.isTableExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(Formatter.formatName(node.getTable())).append(" DROP COLUMN ");
            if (node.isColumnExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(ExpressionFormatter.formatExpression(node.getColumn(), this.parameters));
            return null;
        }

        @Override
        protected Void visitAnalyze(Analyze node, Integer context) {
            this.builder.append("ANALYZE ").append(Formatter.formatName(node.getTableName()));
            this.builder.append(this.formatPropertiesMultiLine(node.getProperties()));
            return null;
        }

        @Override
        protected Void visitAddColumn(AddColumn node, Integer indent) {
            this.builder.append("ALTER TABLE ");
            if (node.isTableExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(node.getName()).append(" ADD COLUMN ");
            if (node.isColumnNotExists()) {
                this.builder.append("IF NOT EXISTS ");
            }
            this.builder.append(this.formatColumnDefinition(node.getColumn()));
            return null;
        }

        @Override
        protected Void visitInsert(Insert node, Integer indent) {
            this.builder.append("INSERT INTO ").append(node.getTarget());
            if (node.getColumns().isPresent()) {
                this.builder.append(" (").append(Joiner.on((String)", ").join((Iterable)node.getColumns().get())).append(")");
            }
            this.builder.append("\n");
            this.process(node.getQuery(), indent);
            return null;
        }

        @Override
        public Void visitSetSession(SetSession node, Integer context) {
            this.builder.append("SET SESSION ").append(node.getName()).append(" = ").append(ExpressionFormatter.formatExpression(node.getValue(), this.parameters));
            return null;
        }

        @Override
        public Void visitResetSession(ResetSession node, Integer context) {
            this.builder.append("RESET SESSION ").append(node.getName());
            return null;
        }

        @Override
        protected Void visitCallArgument(CallArgument node, Integer indent) {
            if (node.getName().isPresent()) {
                this.builder.append(node.getName().get()).append(" => ");
            }
            this.builder.append(ExpressionFormatter.formatExpression(node.getValue(), this.parameters));
            return null;
        }

        @Override
        protected Void visitCall(Call node, Integer indent) {
            this.builder.append("CALL ").append(node.getName()).append("(");
            Iterator<CallArgument> arguments = node.getArguments().iterator();
            while (arguments.hasNext()) {
                this.process(arguments.next(), indent);
                if (!arguments.hasNext()) continue;
                this.builder.append(", ");
            }
            this.builder.append(")");
            return null;
        }

        @Override
        protected Void visitRow(Row node, Integer indent) {
            this.builder.append("ROW(");
            boolean firstItem = true;
            for (Expression item : node.getItems()) {
                if (!firstItem) {
                    this.builder.append(", ");
                }
                this.process(item, indent);
                firstItem = false;
            }
            this.builder.append(")");
            return null;
        }

        @Override
        protected Void visitStartTransaction(StartTransaction node, Integer indent) {
            this.builder.append("START TRANSACTION");
            Iterator<TransactionMode> iterator = node.getTransactionModes().iterator();
            while (iterator.hasNext()) {
                this.builder.append(" ");
                this.process(iterator.next(), indent);
                if (!iterator.hasNext()) continue;
                this.builder.append(",");
            }
            return null;
        }

        @Override
        protected Void visitIsolationLevel(Isolation node, Integer indent) {
            this.builder.append("ISOLATION LEVEL ").append(node.getLevel().getText());
            return null;
        }

        @Override
        protected Void visitTransactionAccessMode(TransactionAccessMode node, Integer context) {
            this.builder.append(node.isReadOnly() ? "READ ONLY" : "READ WRITE");
            return null;
        }

        @Override
        protected Void visitCommit(Commit node, Integer context) {
            this.builder.append("COMMIT");
            return null;
        }

        @Override
        protected Void visitRollback(Rollback node, Integer context) {
            this.builder.append("ROLLBACK");
            return null;
        }

        @Override
        protected Void visitCreateRole(CreateRole node, Integer context) {
            this.builder.append("CREATE ROLE ").append(node.getName());
            if (node.getGrantor().isPresent()) {
                this.builder.append(" WITH ADMIN ").append(Formatter.formatGrantor(node.getGrantor().get()));
            }
            return null;
        }

        @Override
        protected Void visitDropRole(DropRole node, Integer context) {
            this.builder.append("DROP ROLE ").append(node.getName());
            return null;
        }

        @Override
        protected Void visitGrantRoles(GrantRoles node, Integer context) {
            this.builder.append("GRANT ");
            this.builder.append(node.getRoles().stream().map(Expression::toString).collect(Collectors.joining(", ")));
            this.builder.append(" TO ");
            this.builder.append(node.getGrantees().stream().map(Formatter::formatPrincipal).collect(Collectors.joining(", ")));
            if (node.isWithAdminOption()) {
                this.builder.append(" WITH ADMIN OPTION");
            }
            if (node.getGrantor().isPresent()) {
                this.builder.append(" GRANTED BY ").append(Formatter.formatGrantor(node.getGrantor().get()));
            }
            return null;
        }

        @Override
        protected Void visitRevokeRoles(RevokeRoles node, Integer context) {
            this.builder.append("REVOKE ");
            if (node.isAdminOptionFor()) {
                this.builder.append("ADMIN OPTION FOR ");
            }
            this.builder.append(node.getRoles().stream().map(Expression::toString).collect(Collectors.joining(", ")));
            this.builder.append(" FROM ");
            this.builder.append(node.getGrantees().stream().map(Formatter::formatPrincipal).collect(Collectors.joining(", ")));
            if (node.getGrantor().isPresent()) {
                this.builder.append(" GRANTED BY ").append(Formatter.formatGrantor(node.getGrantor().get()));
            }
            return null;
        }

        @Override
        protected Void visitSetRole(SetRole node, Integer context) {
            this.builder.append("SET ROLE ");
            SetRole.Type type = node.getType();
            switch (type) {
                case ALL: 
                case NONE: {
                    this.builder.append(type.toString());
                    break;
                }
                case ROLE: {
                    this.builder.append(node.getRole().get());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported type: " + (Object)((Object)type));
                }
            }
            return null;
        }

        @Override
        public Void visitGrant(Grant node, Integer indent) {
            this.builder.append("GRANT ");
            if (node.getPrivileges().isPresent()) {
                this.builder.append(node.getPrivileges().get().stream().collect(Collectors.joining(", ")));
            } else {
                this.builder.append("ALL PRIVILEGES");
            }
            this.builder.append(" ON ");
            if (node.isTable()) {
                this.builder.append("TABLE ");
            }
            this.builder.append(node.getTableName()).append(" TO ").append(Formatter.formatPrincipal(node.getGrantee()));
            if (node.isWithGrantOption()) {
                this.builder.append(" WITH GRANT OPTION");
            }
            return null;
        }

        @Override
        public Void visitRevoke(Revoke node, Integer indent) {
            this.builder.append("REVOKE ");
            if (node.isGrantOptionFor()) {
                this.builder.append("GRANT OPTION FOR ");
            }
            if (node.getPrivileges().isPresent()) {
                this.builder.append(node.getPrivileges().get().stream().collect(Collectors.joining(", ")));
            } else {
                this.builder.append("ALL PRIVILEGES");
            }
            this.builder.append(" ON ");
            if (node.isTable()) {
                this.builder.append("TABLE ");
            }
            this.builder.append(node.getTableName()).append(" FROM ").append(Formatter.formatPrincipal(node.getGrantee()));
            return null;
        }

        @Override
        public Void visitShowGrants(ShowGrants node, Integer indent) {
            this.builder.append("SHOW GRANTS ");
            if (node.getTableName().isPresent()) {
                this.builder.append("ON ");
                if (node.getTable()) {
                    this.builder.append("TABLE ");
                }
                this.builder.append(node.getTableName().get());
            }
            return null;
        }

        @Override
        protected Void visitShowRoles(ShowRoles node, Integer context) {
            this.builder.append("SHOW ");
            if (node.isCurrent()) {
                this.builder.append("CURRENT ");
            }
            this.builder.append("ROLES");
            if (node.getCatalog().isPresent()) {
                this.builder.append(" FROM ").append(node.getCatalog().get());
            }
            return null;
        }

        @Override
        protected Void visitShowRoleGrants(ShowRoleGrants node, Integer context) {
            this.builder.append("SHOW ROLE GRANTS");
            if (node.getCatalog().isPresent()) {
                this.builder.append(" FROM ").append(node.getCatalog().get());
            }
            return null;
        }

        private void processRelation(Relation relation, Integer indent) {
            if (relation instanceof Table) {
                this.builder.append("TABLE ").append(((Table)relation).getName()).append('\n');
            } else {
                this.process(relation, indent);
            }
        }

        private StringBuilder append(int indent, String value) {
            return this.builder.append(Formatter.indentString(indent)).append(value);
        }

        private static String indentString(int indent) {
            return Strings.repeat((String)SqlFormatter.INDENT, (int)indent);
        }
    }
}

