/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ShowCreateFunction
extends Statement {
    private final QualifiedName name;
    private final Optional<List<String>> parameterTypes;

    public ShowCreateFunction(QualifiedName name, Optional<List<String>> parameterTypes) {
        this(Optional.empty(), name, parameterTypes);
    }

    public ShowCreateFunction(NodeLocation location, QualifiedName name, Optional<List<String>> parameterTypes) {
        this(Optional.of(location), name, parameterTypes);
    }

    private ShowCreateFunction(Optional<NodeLocation> location, QualifiedName name, Optional<List<String>> parameterTypes) {
        super(location);
        this.name = Objects.requireNonNull(name, "name is null");
        this.parameterTypes = Objects.requireNonNull(parameterTypes, "parameterTypes is null");
    }

    public QualifiedName getName() {
        return this.name;
    }

    public Optional<List<String>> getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitShowCreateFunction(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.parameterTypes);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ShowCreateFunction o = (ShowCreateFunction)obj;
        return Objects.equals(this.name, o.name) && Objects.equals(this.parameterTypes, o.parameterTypes);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("parameterTypes", this.parameterTypes).toString();
    }
}

