/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ComparisonExpression
extends Expression {
    private final Operator operator;
    private final Expression left;
    private final Expression right;

    public ComparisonExpression(Operator operator, Expression left, Expression right) {
        this(Optional.empty(), operator, left, right);
    }

    public ComparisonExpression(NodeLocation location, Operator operator, Expression left, Expression right) {
        this(Optional.of(location), operator, left, right);
    }

    private ComparisonExpression(Optional<NodeLocation> location, Operator operator, Expression left, Expression right) {
        super(location);
        Objects.requireNonNull(operator, "type is null");
        Objects.requireNonNull(left, "left is null");
        Objects.requireNonNull(right, "right is null");
        this.operator = operator;
        this.left = left;
        this.right = right;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Expression getLeft() {
        return this.left;
    }

    public Expression getRight() {
        return this.right;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitComparisonExpression(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of((Object)this.left, (Object)this.right);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComparisonExpression that = (ComparisonExpression)o;
        return this.operator == that.operator && Objects.equals(this.left, that.left) && Objects.equals(this.right, that.right);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.operator, this.left, this.right});
    }

    public static enum Operator {
        EQUAL("="),
        NOT_EQUAL("<>"),
        LESS_THAN("<"),
        LESS_THAN_OR_EQUAL("<="),
        GREATER_THAN(">"),
        GREATER_THAN_OR_EQUAL(">="),
        IS_DISTINCT_FROM("IS DISTINCT FROM");

        private final String value;

        private Operator(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public Operator flip() {
            switch (this) {
                case EQUAL: {
                    return EQUAL;
                }
                case NOT_EQUAL: {
                    return NOT_EQUAL;
                }
                case LESS_THAN: {
                    return GREATER_THAN;
                }
                case LESS_THAN_OR_EQUAL: {
                    return GREATER_THAN_OR_EQUAL;
                }
                case GREATER_THAN: {
                    return LESS_THAN;
                }
                case GREATER_THAN_OR_EQUAL: {
                    return LESS_THAN_OR_EQUAL;
                }
                case IS_DISTINCT_FROM: {
                    return IS_DISTINCT_FROM;
                }
            }
            throw new IllegalArgumentException("Unsupported comparison: " + (Object)((Object)this));
        }

        public Operator negate() {
            switch (this) {
                case EQUAL: {
                    return NOT_EQUAL;
                }
                case NOT_EQUAL: {
                    return EQUAL;
                }
                case LESS_THAN: {
                    return GREATER_THAN_OR_EQUAL;
                }
                case LESS_THAN_OR_EQUAL: {
                    return GREATER_THAN;
                }
                case GREATER_THAN: {
                    return LESS_THAN_OR_EQUAL;
                }
                case GREATER_THAN_OR_EQUAL: {
                    return LESS_THAN;
                }
            }
            throw new IllegalArgumentException("Unsupported comparison: " + (Object)((Object)this));
        }
    }
}

