/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.parser;

import com.facebook.presto.sql.parser.IdentifierSymbol;
import com.google.common.collect.Iterables;
import java.util.EnumSet;
import java.util.Objects;

public class SqlParserOptions {
    private final EnumSet<IdentifierSymbol> allowedIdentifierSymbols = EnumSet.noneOf(IdentifierSymbol.class);
    private boolean enhancedErrorHandlerEnabled = true;

    public SqlParserOptions() {
    }

    private SqlParserOptions(EnumSet<IdentifierSymbol> identifierSymbols, boolean enhancedErrorHandlerEnabled) {
        this.enhancedErrorHandlerEnabled = enhancedErrorHandlerEnabled;
        this.allowedIdentifierSymbols.addAll(identifierSymbols);
    }

    public SqlParserOptions allowIdentifierSymbol(Iterable<IdentifierSymbol> identifierSymbols) {
        Iterables.addAll(this.allowedIdentifierSymbols, identifierSymbols);
        return this;
    }

    public EnumSet<IdentifierSymbol> getAllowedIdentifierSymbols() {
        return EnumSet.copyOf(this.allowedIdentifierSymbols);
    }

    public SqlParserOptions allowIdentifierSymbol(IdentifierSymbol ... identifierSymbols) {
        for (IdentifierSymbol identifierSymbol : identifierSymbols) {
            this.allowedIdentifierSymbols.add(Objects.requireNonNull(identifierSymbol, "identifierSymbol is null"));
        }
        return this;
    }

    public SqlParserOptions useEnhancedErrorHandler(boolean enable) {
        this.enhancedErrorHandlerEnabled = enable;
        return this;
    }

    public boolean isEnhancedErrorHandlerEnabled() {
        return this.enhancedErrorHandlerEnabled;
    }

    public static SqlParserOptions copyOf(SqlParserOptions other) {
        return new SqlParserOptions(other.allowedIdentifierSymbols, other.enhancedErrorHandlerEnabled);
    }
}

