/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class CurrentTime
extends Expression {
    private final Type type;
    private final Integer precision;

    public CurrentTime(Type type) {
        this(Optional.empty(), type, null);
    }

    public CurrentTime(NodeLocation location, Type type) {
        this(Optional.of(location), type, null);
    }

    public CurrentTime(Type type, Integer precision) {
        this(Optional.empty(), type, precision);
    }

    public CurrentTime(NodeLocation location, Type type, Integer precision) {
        this(Optional.of(location), type, precision);
    }

    private CurrentTime(Optional<NodeLocation> location, Type type, Integer precision) {
        super(location);
        Objects.requireNonNull(type, "type is null");
        this.type = type;
        this.precision = precision;
    }

    public Type getType() {
        return this.type;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCurrentTime(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CurrentTime that = (CurrentTime)o;
        return this.type == that.type && Objects.equals(this.precision, that.precision);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.precision});
    }

    public static enum Type {
        TIME("current_time"),
        DATE("current_date"),
        TIMESTAMP("current_timestamp"),
        LOCALTIME("localtime"),
        LOCALTIMESTAMP("localtimestamp");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

