/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Window;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class FunctionCall
extends Expression {
    private final QualifiedName name;
    private final Optional<Window> window;
    private final Optional<Expression> filter;
    private final boolean distinct;
    private final List<Expression> arguments;

    public FunctionCall(QualifiedName name, List<Expression> arguments) {
        this(Optional.empty(), name, Optional.empty(), Optional.empty(), false, arguments);
    }

    public FunctionCall(NodeLocation location, QualifiedName name, List<Expression> arguments) {
        this(Optional.of(location), name, Optional.empty(), Optional.empty(), false, arguments);
    }

    public FunctionCall(QualifiedName name, boolean distinct, List<Expression> arguments) {
        this(Optional.empty(), name, Optional.empty(), Optional.empty(), distinct, arguments);
    }

    public FunctionCall(NodeLocation location, QualifiedName name, boolean distinct, List<Expression> arguments) {
        this(Optional.of(location), name, Optional.empty(), Optional.empty(), distinct, arguments);
    }

    public FunctionCall(QualifiedName name, Optional<Window> window, boolean distinct, List<Expression> arguments) {
        this(Optional.empty(), name, window, Optional.empty(), distinct, arguments);
    }

    public FunctionCall(QualifiedName name, Optional<Window> window, Optional<Expression> filter, boolean distinct, List<Expression> arguments) {
        this(Optional.empty(), name, window, filter, distinct, arguments);
    }

    public FunctionCall(NodeLocation location, QualifiedName name, Optional<Window> window, Optional<Expression> filter, boolean distinct, List<Expression> arguments) {
        this(Optional.of(location), name, window, filter, distinct, arguments);
    }

    private FunctionCall(Optional<NodeLocation> location, QualifiedName name, Optional<Window> window, Optional<Expression> filter, boolean distinct, List<Expression> arguments) {
        super(location);
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(window, "window is null");
        Objects.requireNonNull(filter, "filter is null");
        Objects.requireNonNull(arguments, "arguments is null");
        this.name = name;
        this.window = window;
        this.distinct = distinct;
        this.arguments = arguments;
        this.filter = filter;
    }

    public QualifiedName getName() {
        return this.name;
    }

    public Optional<Window> getWindow() {
        return this.window;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public List<Expression> getArguments() {
        return this.arguments;
    }

    public Optional<Expression> getFilter() {
        return this.filter;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitFunctionCall(this, context);
    }

    public List<Node> getChildren() {
        ImmutableList.Builder nodes = ImmutableList.builder();
        this.window.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        this.filter.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        nodes.addAll(this.arguments);
        return nodes.build();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionCall o = (FunctionCall)obj;
        return Objects.equals(this.name, o.name) && Objects.equals(this.window, o.window) && Objects.equals(this.filter, o.filter) && Objects.equals(this.distinct, o.distinct) && Objects.equals(this.arguments, o.arguments);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.distinct, this.window, this.filter, this.arguments);
    }
}

