/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.util;

import com.facebook.presto.sql.tree.Node;
import com.google.common.collect.Iterables;
import com.google.common.collect.TreeTraverser;
import java.util.Objects;
import java.util.stream.Stream;

public class AstUtils {
    public static boolean nodeContains(Node node, Node subNode) {
        Objects.requireNonNull(node, "node is null");
        Objects.requireNonNull(subNode, "subNode is null");
        return AstUtils.preOrder(node).anyMatch(childNode -> childNode == subNode);
    }

    public static Stream<Node> preOrder(Node node) {
        return TreeTraverser.using(n -> Iterables.unmodifiableIterable(n.getChildren())).preOrderTraversal((Object)Objects.requireNonNull(node, "node is null")).stream();
    }

    private AstUtils() {
    }
}

