/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class CreateSchema
extends Statement {
    private final QualifiedName schemaName;
    private final boolean notExists;
    private final Map<String, Expression> properties;

    public CreateSchema(QualifiedName schemaName, boolean notExists, Map<String, Expression> properties) {
        this(Optional.empty(), schemaName, notExists, properties);
    }

    public CreateSchema(NodeLocation location, QualifiedName schemaName, boolean notExists, Map<String, Expression> properties) {
        this(Optional.of(location), schemaName, notExists, properties);
    }

    private CreateSchema(Optional<NodeLocation> location, QualifiedName schemaName, boolean notExists, Map<String, Expression> properties) {
        super(location);
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.notExists = notExists;
        this.properties = ImmutableMap.copyOf(Objects.requireNonNull(properties, "properties is null"));
    }

    public QualifiedName getSchemaName() {
        return this.schemaName;
    }

    public boolean isNotExists() {
        return this.notExists;
    }

    public Map<String, Expression> getProperties() {
        return this.properties;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCreateSchema(this, context);
    }

    public List<Node> getChildren() {
        ImmutableList.Builder nodes = ImmutableList.builder();
        nodes.addAll(this.properties.values());
        return nodes.build();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.schemaName, this.notExists, this.properties);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CreateSchema o = (CreateSchema)obj;
        return Objects.equals(this.schemaName, o.schemaName) && Objects.equals(this.notExists, o.notExists) && Objects.equals(this.properties, o.properties);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("schemaName", (Object)this.schemaName).add("notExists", this.notExists).add("properties", this.properties).toString();
    }
}

