/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.ExplainOption;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ExplainFormat
extends ExplainOption {
    private final Type type;

    public ExplainFormat(Type type) {
        this(Optional.empty(), type);
    }

    public ExplainFormat(NodeLocation location, Type type) {
        this(Optional.of(location), type);
    }

    private ExplainFormat(Optional<NodeLocation> location, Type type) {
        super(location);
        this.type = Objects.requireNonNull(type, "type is null");
    }

    public Type getType() {
        return this.type;
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.type});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ExplainFormat o = (ExplainFormat)obj;
        return Objects.equals((Object)this.type, (Object)o.type);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).toString();
    }

    public static enum Type {
        TEXT,
        GRAPHVIZ;

    }
}

