/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.QueryBody;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.sql.tree.With;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Query
extends Statement {
    private final Optional<With> with;
    private final QueryBody queryBody;
    private final List<SortItem> orderBy;
    private final Optional<String> limit;

    public Query(Optional<With> with, QueryBody queryBody, List<SortItem> orderBy, Optional<String> limit) {
        this(Optional.empty(), with, queryBody, orderBy, limit);
    }

    public Query(NodeLocation location, Optional<With> with, QueryBody queryBody, List<SortItem> orderBy, Optional<String> limit) {
        this(Optional.of(location), with, queryBody, orderBy, limit);
    }

    private Query(Optional<NodeLocation> location, Optional<With> with, QueryBody queryBody, List<SortItem> orderBy, Optional<String> limit) {
        super(location);
        Objects.requireNonNull(with, "with is null");
        Objects.requireNonNull(queryBody, "queryBody is null");
        Objects.requireNonNull(orderBy, "orderBy is null");
        Objects.requireNonNull(limit, "limit is null");
        this.with = with;
        this.queryBody = queryBody;
        this.orderBy = orderBy;
        this.limit = limit;
    }

    public Optional<With> getWith() {
        return this.with;
    }

    public QueryBody getQueryBody() {
        return this.queryBody;
    }

    public List<SortItem> getOrderBy() {
        return this.orderBy;
    }

    public Optional<String> getLimit() {
        return this.limit;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitQuery(this, context);
    }

    public List<Node> getChildren() {
        ImmutableList.Builder nodes = ImmutableList.builder();
        this.with.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        return nodes.add((Object)this.queryBody).addAll(this.orderBy).build();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("with", this.with.orElse(null)).add("queryBody", (Object)this.queryBody).add("orderBy", this.orderBy).add("limit", this.limit.orElse(null)).omitNullValues().toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Query o = (Query)obj;
        return Objects.equals(this.with, o.with) && Objects.equals(this.queryBody, o.queryBody) && Objects.equals(this.orderBy, o.orderBy) && Objects.equals(this.limit, o.limit);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.with, this.queryBody, this.orderBy, this.limit);
    }
}

