/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.JoinCriteria;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.Relation;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Join
extends Relation {
    private final Type type;
    private final Relation left;
    private final Relation right;
    private final Optional<JoinCriteria> criteria;

    public Join(Type type, Relation left, Relation right, Optional<JoinCriteria> criteria) {
        this(Optional.empty(), type, left, right, criteria);
    }

    public Join(NodeLocation location, Type type, Relation left, Relation right, Optional<JoinCriteria> criteria) {
        this(Optional.of(location), type, left, right, criteria);
    }

    private Join(Optional<NodeLocation> location, Type type, Relation left, Relation right, Optional<JoinCriteria> criteria) {
        super(location);
        Objects.requireNonNull(left, "left is null");
        Objects.requireNonNull(right, "right is null");
        if (type == Type.CROSS || type == Type.IMPLICIT) {
            Preconditions.checkArgument((!criteria.isPresent() ? 1 : 0) != 0, (String)"%s join cannot have join criteria", (Object[])new Object[]{type});
        } else {
            Preconditions.checkArgument((boolean)criteria.isPresent(), (Object)"No join criteria specified");
        }
        this.type = type;
        this.left = left;
        this.right = right;
        this.criteria = criteria;
    }

    public Type getType() {
        return this.type;
    }

    public Relation getLeft() {
        return this.left;
    }

    public Relation getRight() {
        return this.right;
    }

    public Optional<JoinCriteria> getCriteria() {
        return this.criteria;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitJoin(this, context);
    }

    public List<Node> getChildren() {
        ImmutableList.Builder nodes = ImmutableList.builder();
        nodes.add((Object)this.left);
        nodes.add((Object)this.right);
        this.criteria.map(JoinCriteria::getNodes).ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).addAll(arg_0));
        return nodes.build();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("left", (Object)this.left).add("right", (Object)this.right).add("criteria", this.criteria).omitNullValues().toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Join join = (Join)o;
        return this.type == join.type && Objects.equals(this.left, join.left) && Objects.equals(this.right, join.right) && Objects.equals(this.criteria, join.criteria);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.left, this.right, this.criteria});
    }

    public static enum Type {
        CROSS,
        INNER,
        LEFT,
        RIGHT,
        FULL,
        IMPLICIT;

    }
}

