/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.IntervalLiteral;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.StringLiteral;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;

public class AtTimeZone
extends Expression {
    private final Expression value;
    private final Expression timeZone;

    public AtTimeZone(Expression value, Expression timeZone) {
        this(Optional.empty(), value, timeZone);
    }

    public AtTimeZone(NodeLocation location, Expression value, Expression timeZone) {
        this(Optional.of(location), value, timeZone);
    }

    private AtTimeZone(Optional<NodeLocation> location, Expression value, Expression timeZone) {
        super(location);
        Preconditions.checkArgument((timeZone instanceof IntervalLiteral || timeZone instanceof StringLiteral ? 1 : 0) != 0, (Object)"timeZone must be IntervalLiteral or StringLiteral");
        this.value = Objects.requireNonNull(value, "value is null");
        this.timeZone = Objects.requireNonNull(timeZone, "timeZone is null");
    }

    public Expression getValue() {
        return this.value;
    }

    public Expression getTimeZone() {
        return this.timeZone;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitAtTimeZone(this, context);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value, this.timeZone);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AtTimeZone atTimeZone = (AtTimeZone)obj;
        return Objects.equals(this.value, atTimeZone.value) && Objects.equals(this.timeZone, atTimeZone.timeZone);
    }
}

