/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.ColumnDefinition;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;

public class AddColumn
extends Statement {
    private final QualifiedName name;
    private final ColumnDefinition column;

    public AddColumn(QualifiedName name, ColumnDefinition column) {
        this(Optional.empty(), name, column);
    }

    public AddColumn(NodeLocation location, QualifiedName name, ColumnDefinition column) {
        this(Optional.of(location), name, column);
    }

    private AddColumn(Optional<NodeLocation> location, QualifiedName name, ColumnDefinition column) {
        super(location);
        this.name = Objects.requireNonNull(name, "table is null");
        this.column = Objects.requireNonNull(column, "column is null");
    }

    public QualifiedName getName() {
        return this.name;
    }

    public ColumnDefinition getColumn() {
        return this.column;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitAddColumn(this, context);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.column);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AddColumn o = (AddColumn)obj;
        return Objects.equals(this.name, o.name) && Objects.equals(this.column, o.column);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("column", (Object)this.column).toString();
    }
}

