/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;

public class Prepare
extends Statement {
    private final String name;
    private final Statement statement;

    public Prepare(NodeLocation location, String name, Statement statement) {
        this(Optional.of(location), name, statement);
    }

    public Prepare(String name, Statement statement) {
        this(Optional.empty(), name, statement);
    }

    private Prepare(Optional<NodeLocation> location, String name, Statement statement) {
        super(location);
        this.name = Objects.requireNonNull(name, "name is null");
        this.statement = Objects.requireNonNull(statement, "statement is null");
    }

    public String getName() {
        return this.name;
    }

    public Statement getStatement() {
        return this.statement;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitPrepare(this, context);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.statement);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Prepare o = (Prepare)obj;
        return Objects.equals(this.name, o.name) && Objects.equals(this.statement, o.statement);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("statement", (Object)this.statement).toString();
    }
}

