/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql;

import com.facebook.presto.sql.tree.AliasedRelation;
import com.facebook.presto.sql.tree.AllColumns;
import com.facebook.presto.sql.tree.CoalesceExpression;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.GroupBy;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.QueryBody;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.Row;
import com.facebook.presto.sql.tree.SearchedCaseExpression;
import com.facebook.presto.sql.tree.Select;
import com.facebook.presto.sql.tree.SelectItem;
import com.facebook.presto.sql.tree.SingleColumn;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.sql.tree.StringLiteral;
import com.facebook.presto.sql.tree.Table;
import com.facebook.presto.sql.tree.TableSubquery;
import com.facebook.presto.sql.tree.Values;
import com.facebook.presto.sql.tree.WhenClause;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;

public final class QueryUtil {
    private QueryUtil() {
    }

    public static Expression nameReference(String name) {
        return new QualifiedNameReference(QualifiedName.of(name, new String[0]));
    }

    public static SelectItem unaliasedName(String name) {
        return new SingleColumn(QueryUtil.nameReference(name));
    }

    public static SelectItem aliasedName(String name, String alias) {
        return new SingleColumn(QueryUtil.nameReference(name), alias);
    }

    public static Select selectList(Expression ... expressions) {
        ImmutableList.Builder items = ImmutableList.builder();
        for (Expression expression : expressions) {
            items.add((Object)new SingleColumn(expression));
        }
        return new Select(false, (List<SelectItem>)items.build());
    }

    public static Select selectList(SelectItem ... items) {
        return new Select(false, (List<SelectItem>)ImmutableList.copyOf((Object[])items));
    }

    public static Select selectAll(List<SelectItem> items) {
        return new Select(false, items);
    }

    public static Table table(QualifiedName name) {
        return new Table(name);
    }

    public static Relation subquery(Query query) {
        return new TableSubquery(query);
    }

    public static SortItem ascending(String name) {
        return new SortItem(QueryUtil.nameReference(name), SortItem.Ordering.ASCENDING, SortItem.NullOrdering.UNDEFINED);
    }

    public static Expression logicalAnd(Expression left, Expression right) {
        return new LogicalBinaryExpression(LogicalBinaryExpression.Type.AND, left, right);
    }

    public static Expression equal(Expression left, Expression right) {
        return new ComparisonExpression(ComparisonExpression.Type.EQUAL, left, right);
    }

    public static Expression caseWhen(Expression operand, Expression result) {
        return new SearchedCaseExpression((List<WhenClause>)ImmutableList.of((Object)new WhenClause(operand, result)), Optional.empty());
    }

    public static Expression functionCall(String name, Expression ... arguments) {
        return new FunctionCall(new QualifiedName(name), (List<Expression>)ImmutableList.copyOf((Object[])arguments));
    }

    public static Values values(Row ... row) {
        return new Values((List<Expression>)ImmutableList.copyOf((Object[])row));
    }

    public static Row row(Expression ... values) {
        return new Row((List<Expression>)ImmutableList.copyOf((Object[])values));
    }

    public static Relation aliased(Relation relation, String alias, List<String> columnAliases) {
        return new AliasedRelation(relation, alias, columnAliases);
    }

    public static SelectItem aliasedNullToEmpty(String column, String alias) {
        return new SingleColumn((Expression)new CoalesceExpression(QueryUtil.nameReference(column), new StringLiteral("")), alias);
    }

    public static List<SortItem> ordering(SortItem ... items) {
        return ImmutableList.copyOf((Object[])items);
    }

    public static Query simpleQuery(Select select, Relation from) {
        return QueryUtil.simpleQuery(select, from, Optional.empty(), (List<SortItem>)ImmutableList.of());
    }

    public static Query simpleQuery(Select select, Relation from, List<SortItem> ordering) {
        return QueryUtil.simpleQuery(select, from, Optional.empty(), ordering);
    }

    public static Query simpleQuery(Select select, Relation from, Expression where) {
        return QueryUtil.simpleQuery(select, from, Optional.of(where), (List<SortItem>)ImmutableList.of());
    }

    public static Query simpleQuery(Select select, Relation from, Expression where, List<SortItem> ordering) {
        return QueryUtil.simpleQuery(select, from, Optional.of(where), ordering);
    }

    public static Query simpleQuery(Select select, Relation from, Optional<Expression> where, List<SortItem> ordering) {
        return QueryUtil.simpleQuery(select, from, where, Optional.empty(), Optional.empty(), ordering, Optional.empty());
    }

    public static Query simpleQuery(Select select, Relation from, Optional<Expression> where, Optional<GroupBy> groupBy, Optional<Expression> having, List<SortItem> ordering, Optional<String> limit) {
        return QueryUtil.query(new QuerySpecification(select, Optional.of(from), where, groupBy, having, ordering, limit));
    }

    public static Query singleValueQuery(String columnName, String value) {
        Values values = QueryUtil.values(QueryUtil.row(new StringLiteral(value)));
        return QueryUtil.simpleQuery(QueryUtil.selectList(new AllColumns()), QueryUtil.aliased(values, "t", (List<String>)ImmutableList.of((Object)columnName)));
    }

    public static Query query(QueryBody body) {
        return new Query(Optional.empty(), body, (List<SortItem>)ImmutableList.of(), Optional.empty(), Optional.empty());
    }
}

