/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.NodeLocation;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class Extract
extends Expression {
    private final Expression expression;
    private final Field field;

    public Extract(Expression expression, Field field) {
        this(Optional.empty(), expression, field);
    }

    public Extract(NodeLocation location, Expression expression, Field field) {
        this(Optional.of(location), expression, field);
    }

    private Extract(Optional<NodeLocation> location, Expression expression, Field field) {
        super(location);
        Objects.requireNonNull(expression, "expression is null");
        Objects.requireNonNull(field, "field is null");
        this.expression = expression;
        this.field = field;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public Field getField() {
        return this.field;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitExtract(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Extract that = (Extract)o;
        if (!this.expression.equals(that.expression)) {
            return false;
        }
        return this.field == that.field;
    }

    @Override
    public int hashCode() {
        int result = this.expression.hashCode();
        result = 31 * result + this.field.hashCode();
        return result;
    }

    public static enum Field {
        YEAR,
        QUARTER,
        MONTH,
        WEEK,
        DAY,
        DAY_OF_MONTH,
        DAY_OF_WEEK,
        DOW,
        DAY_OF_YEAR,
        DOY,
        YEAR_OF_WEEK,
        YOW,
        HOUR,
        MINUTE,
        SECOND,
        TIMEZONE_MINUTE,
        TIMEZONE_HOUR;

    }
}

